function applyoptions(md,data,options_structure)
%APPLYOPTIONS - apply the options to current plot
%
%   Usage:
%      applyoptions(md,data,options_structure)
%
%   See also: PLOTMODEL, PARSE_OPTIONS

%fontsize
if ~isnan(options_structure.fontsize),
	fontsize=options_structure.fontsize;
else
	fontsize=14;
end

%fontweight
if ~isnan(options_structure.fontweight),
	fontweight=options_structure.fontweight;
else
	fontweight='normal';
end

%title
if iscell(options_structure.title),
	title(options_structure.title,'FontSize',fontsize,'FontWeight',fontweight);
else
	if ~isnan(options_structure.title),
		title(options_structure.title,'FontSize',fontsize,'FontWeight',fontweight);
	end
end

%xlabel
if ~isnan(options_structure.xlabel),
	xlabel(options_structure.xlabel,'FontSize',fontsize,'FontWeight',fontweight);
end

%ylabel
if ~isnan(options_structure.ylabel),
	ylabel(options_structure.ylabel,'FontSize',fontsize,'FontWeight',fontweight);
end

%zlabel
if ~isnan(options_structure.zlabel),
	zlabel(options_structure.zlabel,'FontSize',fontsize,'FontWeight',fontweight);
end

%view 
if ~isnan(options_structure.view),
	view(options_structure.view);
else
	if strcmpi(md.type,'3d') & isnan(options_structure.layer),
		view(3);
	else
		view(2);
	end
end

%xlim
if ~isnan(options_structure.xlim),
	xlim(options_structure.xlim);
end

%ylim
if ~isnan(options_structure.ylim),
	ylim(options_structure.ylim);
end

%zlim
if ~isnan(options_structure.zlim),
	zlim(options_structure.zlim);
end

%Basinzoom
if ~isnan(options_structure.basinzoom),                                                                                                                         
	basinzoom(options_structure.basinzoom,options_structure.unitmultiplier);                                                                                                                          end

%Caxis
if ~isnan(options_structure.caxis),
	caxis(options_structure.caxis);
end

%shading
if ~isnan(options_structure.shading),
	shading(options_structure.shading);
end

%grid
if ~isnan(options_structure.grid) & strcmpi(options_structure.grid,'on'),
	grid on;
end

%colormap
if ~isnan(options_structure.colormap),
	h=colormap(options_structure.colormap);
end

%wrapping
if ~isnan(options_structure.wrapping),
	if  isnan(options_structure.colormap)
		h=jet;
	end
	colormap(repmat(h,options_structure.wrapping,1));
end

%colorbar
if options_structure.colorbar~=0,
	c=colorbar;set(c,'FontSize',fontsize);
	if ~isnan(options_structure.wrapping)
		lim=get(c,'Ylim');
		lim=[lim(1) lim(1)+(lim(2)-lim(1))/options_structure.wrapping];
		set(c,'Ylim',lim);
	end
	if ~isnan(options_structure.colorbarpos),
		set(c,'Position',options_structure.colorbarpos);
	end
	if ~isnan(options_structure.log),
		logvalue=options_structure.log;

		scalestring=get(c,'YTickLabel');
		scalevalues=get(c,'YTick');
		scaleminmax=caxis;
		numvalues=length(scalevalues);

		scalestring=[];
		for i=1:numvalues,
			fraction=(scalevalues(i)-scaleminmax(1))/(scaleminmax(2)-scaleminmax(1));
			scalevalues(i)=round_ice(logvalue^scalevalues(i),2);
			scalestring=[scalestring; sprintf('%8.4g',scalevalues(i))];
		end
		set(c,'YTickLabel',scalestring);
		set(c,'FontSize',fontsize);
	end
	if ~isnan(options_structure.colorbartitle),
		backup=gca;
		axes(c);lab=ylabel(options_structure.colorbartitle);set(lab,'Rotation',-90);set(lab,'VerticalAlignment','bottom');
		axes(backup);
	end
%colorbar OFF
else
	colorbar('off');
end

%area
if ~isnan(options_structure.area),
	antzoom(options_structure.area);
end

%expdisp
if iscell(options_structure.expdisp) | ~isnan(options_structure.expdisp),
	for i=1:length(options_structure.expdisp),
		filename=options_structure.expdisp{i};
		style=options_structure.expstyle{i};
		expdisp(filename,gcf,style,options_structure.unitmultiplier);
	end
end

%text (default value is empty, not NaN...)
if ~isempty(options_structure.text)
	for i=1:length(options_structure.text);
		textstring=options_structure.text{i};
		textweight=options_structure.textweight{i};
		textsize=options_structure.textsize{i};
		textcolor=options_structure.textcolor{i};
		textposition=options_structure.textposition{i};
		text(textposition(1),textposition(2),textstring,'FontSize',textsize,'FontWeight',textweight,'Color',textcolor);
	end
end

%latlon
if (iscell(options_structure.latlon) | ~isnan(options_structure.latlon)),
	latlonoverlay(options_structure);
end

%north arrow
if ~isnan(options_structure.northarrow),
	northarrow(options_structure.northarrow);
end

%Scale ruler
if ~isnan(options_structure.scaleruler),
	scaleruler(options_structure.scaleruler);
end

%axis
if ~isnan(options_structure.axis)
	eval(['axis ' options_structure.axis]);
end

%streamliness
if iscell(options_structure.streamlines) | ~isnan(options_structure.streamlines),
	plot_streamlines(md,options_structure);
end

%contours
if iscell(options_structure.contourlevels) | ~isnan(options_structure.contourlevels),
	plot_contour(md,data,options_structure);
end
