function optionstruct=modeldefault_process(options),
%MODELDEFAULT_PROCESS - process modeldefault options
%
%   Usage:
%      optionstruct=modeldefault_process(options)

%retrieve some paths
global ISSM_DIR
modeldatapath='/u/astrid-r1b/larour/ModelData';

%initialize output
optionstruct=struct();

%domainoutline
optionstruct.domainoutline=getfieldvalueerr(options,'domainoutline');

%resolution
optionstruct.resolution=getfieldvalue(options,'resolution',10000);
disp(sprintf('   %-18s: %g','resolution',optionstruct.resolution));

%iceshelves
iceshelves=[ISSM_DIR '/../models/Antarctica/Exp_Par/Iceshelves.exp'];
optionstruct.iceshelves=getfieldvalue(options,'iceshelves',iceshelves);
disp(sprintf('   %-18s: %s','iceshelves',optionstruct.iceshelves));

%islands
islands=[ISSM_DIR '/../models/Antarctica/Exp_Par/Islands.exp'];
optionstruct.islands=getfieldvalue(options,'islands',islands);
disp(sprintf('   %-18s: %s','islands',optionstruct.islands));

%thicknesspath
thicknesspath=[modeldatapath '/BedMap/gridded/thickness.mat'];
optionstruct.thicknesspath=getfieldvalue(options,'thicknesspath',thicknesspath);
disp(sprintf('   %-18s: %s','thicknesspath',optionstruct.thicknesspath));

%firnpath
firnpath=[modeldatapath '/BroekeFirn1km/firn.mat'];
optionstruct.firnpath=getfieldvalue(options,'firnpath',firnpath);
disp(sprintf('   %-18s: %s','firnpath',optionstruct.firnpath));

%surfacepath
surfacepath=[modeldatapath '/BamberDEMAntarctica1km/surface_smooth30_lowslope.mat'];
optionstruct.surfacepath=getfieldvalue(options,'surfacepath',surfacepath);
disp(sprintf('   %-18s: %s','surfacepath',optionstruct.surfacepath));

%mosaicpath
mosaicpath=[modeldatapath '/RignotAntarcticaVelMosaicRampErsAlos/RignotAntVel.mat'];
optionstruct.mosaicpath=getfieldvalue(options,'mosaicpath',mosaicpath);
disp(sprintf('   %-18s: %s','mosaicpath',optionstruct.mosaicpath));

%temperaturepath
temperaturepath=[modeldatapath '/GiovinettoZwallyTemperatures92/Giovinetto_Temperatures.mat'];
optionstruct.temperaturepath=getfieldvalue(options,'temperaturepath',temperaturepath);
disp(sprintf('   %-18s: %s','temperaturepath',optionstruct.temperaturepath));

%heatfluxpath
heatfluxpath=[modeldatapath '/HeatfluxAntarctica/RignotHeatFlux.mat'];
optionstruct.heatfluxpath=getfieldvalue(options,'heatfluxpath',heatfluxpath);
disp(sprintf('   %-18s: %s','heatfluxpath',optionstruct.heatfluxpath));

%numlayers
optionstruct.numlayers=getfieldvalue(options,'numlayers',0);
disp(sprintf('   %-18s: %g','numlayers',optionstruct.numlayers));

%extrusionexponent
optionstruct.extrusionexponent=getfieldvalue(options,'extrusionexponent',3);
disp(sprintf('   %-18s: %g','extrusionexponent',optionstruct.extrusionexponent));


%elementstype
if optionstruct.numlayers>0,
	elementstype='pattyn';
else
	elementstype='macayeal';
end
optionstruct.elementstype=getfieldvalue(options,'elementstype',elementstype);
disp(sprintf('   %-18s: %s','elementstype',optionstruct.elementstype));
