function value=getfieldvalueerr(pairoptions,field),
%GETFIELDVALUEERR - get the value of an option
%
%   Usage:
%      value=getfieldvalueerr(pairoptions,field)
%
%   Find an option value from a field. If the field is not
%   found, an error message will be displayed
%
%   Examples:
%      value=getfieldvalueerr(options,'caxis');

%some argument checking: 
if ~ischar(field),
	error('getfieldvalueerr error message: field should be a string');
end

%Recover option
if ~exist(pairoptions,field)
	error(['error message: field ' field ' has not been provided'])
else
	for i=1:size(pairoptions.list,1),
		if strcmpi(pairoptions.list{i,1},field)
			value=pairoptions.list{i,2};
			return
		end
	end
end
