%Test Name: SquareSheetConstrainedStressFS
%md=triangle(model(),'../Exp/Square.exp',180000.);
md=triangle(model(),'../Exp/Square.exp',180000.);
md=setmask(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=extrude(md,2,1.);
md=setflowequation(md,'FS','all');
md.cluster=generic('name',oshostname(),'np',2);
md.flowequation.fe_FS='TaylorHood';
md=solve(md,'Stressbalance');

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure'};
field_tolerances={1e-09,1e-09,1e-09,1e-09,1e-09};
field_values={...
	(md.results.StressbalanceSolution.Vx),...
	(md.results.StressbalanceSolution.Vy),...
	(md.results.StressbalanceSolution.Vz),...
	(md.results.StressbalanceSolution.Vel),...
	(md.results.StressbalanceSolution.Pressure),...
	};
