function [hutterflag macayealflag pattynflag stokesflag filltype]=recover_areas(md,varargin);
%RECOVER_AREAS - flag the element depending on the physical model that is assigned to them
%
%   This routine is called by setelementstype, do not use
%
%   Usage:
%      [hutterflag macayealflag pattynflag stokesflag filltype]=recover_areas(md,varargin);

	%go through varargin, extract options and plug them into subtype options, by order of appearance
	options=pairoptions(varargin{:});
	options=deleteduplicates(options,1);

	%recover elements distribution
	hutterflag  =BuildFlag(md,getfieldvalue(options,'hutter',''));
	macayealflag=BuildFlag(md,getfieldvalue(options,'macayeal',''));
	pattynflag  =BuildFlag(md,getfieldvalue(options,'pattyn',''));
	stokesflag  =BuildFlag(md,getfieldvalue(options,'stokes',''));
	hutterflag  =BuildFlag(md,getfieldvalue(options,'hutter',''));
	filltype    =getfieldvalue(options,'fill','none');

end %end function


function flag=BuildFlag(md,area),
	if ischar(area),
		if isempty(area),
			flag=zeros(md.numberofelements,1);
			invert=0;
		elseif strcmpi(area,'all')
			flag=ones(md.numberofelements,1);
			invert=0;
		else
			%make sure that we actually don't want the elements outside the domain outline!
			if strcmpi(area(1),'~'),
				area=area(2:length(area));
				invert=1;
			else
				invert=0;
			end
			%ok, flag elements
			flag=ContourToMesh(md.elements(:,1:3),md.x,md.y,expread(area,1),'element',1);
		end
		if invert,
			flag=~flag;
		end
	elseif isfloat(area),
		if size(area,1)~=md.numberofelements,
			setelementstypeusage();
			error('Flags for elements_type must be of same size as number of elements in model');
		end
		flag=area;
	else
		error('Invalide elements_type option');
	end
end
