function md=parametercontrol(md,varargin),
%PARAMETERCONTROL - control method parameterization
%
%   Usage:
%       md=parametercontrol(md,varargin)

%process options
options=pairoptions(varargin{:});

%control type and analysis
md.control_type='drag';
md.control_analysis=1;

%nsteps
nsteps=getfieldvalue(options,'nsteps',100);
if (length(nsteps)~=1 | nsteps<=0 | floor(nsteps)~=nsteps)
	md.nsteps=100;
else
	md.nsteps=nsteps;
end

%cm_min
cm_min=getfieldvalue(options,'cm_min',1);
if (length(cm_min)~=1)
	md.cm_min=1;
else
	md.cm_min=cm_min;
end

%cm_max
cm_max=getfieldvalue(options,'cm_max',180);
if (length(cm_max)~=1)
	md.cm_max=180;
else
	md.cm_max=cm_max;
end

%cm_noisedmp
cm_noisedmp=getfieldvalue(options,'cm_noisedmp',5*10^-5);
if (length(cm_noisedmp)~=1)
	md.cm_noisedmp=5*10^-5;
else
	md.cm_noisedmp=cm_noisedmp;
end

%eps_cm
eps_cm=getfieldvalue(options,'eps_cm',NaN);
if (length(eps_cm)~=1 | eps_cm<0 )
	md.eps_cm=NaN;
else
	md.eps_cm=eps_cm;
end

%maxiter
maxiter=getfieldvalue(options,'maxiter',10*ones(md.nsteps,1));
if (any(maxiter<0) | any(floor(maxiter)~=maxiter))
	md.maxiter=10*ones(md.nsteps,1);
else
	md.maxiter=repmat(maxiter(:),md.nsteps,1);
	md.maxiter(md.nsteps+1:end)=[];
end

%cm_jump
cm_jump=getfieldvalue(options,'cm_jump',0.8*ones(md.nsteps,1));
if ~isreal(cm_jump)
	md.cm_jump=0.8*ones(md.nsteps,1);
else
	md.cm_jump=repmat(cm_jump(:),md.nsteps,1);
	md.cm_jump(md.nsteps+1:end)=[];
end

%fit
found=0;
if exist(options,'fit'),
	fit=getfieldvalue(options,'fit');
	if ~any(fit~=0 & fit~=1 & fit~=2),
		md.fit=repmat(fit(:),md.nsteps,1);
		md.fit(md.nsteps+1:end)=[];
		found=1;
	end
end
if ~found
	third=ceil(md.nsteps/3);
	md.fit=[2*ones(third,1);0*ones(third,1);repmat([0;0;2;0],third,1)];
	md.fit(md.nsteps+1:end)=[];
end

%optscal
found=0;
if exist(options,'optscal'),
	optscal=getfieldvalue(options,'optscal');
	if ~any(optscal<0),
		md.optscal=repmat(optscal(:),md.nsteps,1);
		md.optscal(md.nsteps+1:end)=[];
		found=1;
	end
end
if ~found
	third=ceil(md.nsteps/3);
	md.optscal=[15*ones(third,1);10*ones(third,1);repmat([10;10;20;10],third,1)];
	md.optscal(md.nsteps+1:end)=[];
end
