function value=getfieldvalue(pairoptions,field,varargin),
%GETOPTION - get the value of an option
%
%   Usage:
%      value=getfieldvalue(pairoptions,field,varargin)
%
%   Find an option value from a field. A default option
%   can be given in input if the field does not exist
%
%   Examples:
%      value=getfieldvalue(options,'caxis');
%      value=getfieldvalue(options,'caxis',[0 2]);

%some argument checking: 
if ((nargin~=2 & nargin~=3) | (nargout~=1)),
	help getfieldvalue
	error('getfieldvalue error message: bad usage');
end

if ~ischar(field),
	error('getfieldvalue error message: field should be a string');
end

%Recover option
if nargin==3,
	value=varargin{1};
else
	value='option not found';
end
for i=1:size(pairoptions.list,1),
	if strcmpi(pairoptions.list{i,1},field)
		value=pairoptions.list{i,2};
		return
	end
end
