function pairoptions=buildlist(pairoptions,varargin),
%BUILDLIST - build list of pairoptions from input
%
%   Usage:
%      pairoptions=buildlist(pairoptions,varargin)

%check length of input
if mod((nargin-1),2),
	error('buildlist error message: an even number of pairoptions is required')
end

%go through varargin and build list of pairoptions
for i=1:(nargin-1)/2,
	if ischar(varargin{2*i-1}),
		pairoptions.list{end+1,1}=varargin{2*i-1};
		pairoptions.list{end,2}=varargin{2*i};
	else
		%option is not a string, ignore it
		disp(['buildlist info: option number ' num2str(i) ' is not a string, it will be ignored']);
		continue
	end
end
