#!/bin/bash
#This script compiles and links MITgcm

#recover hostname and model path:
hostname="$1"
modelpath="$2"

if [ -e ~/.bashrc ]; then
    source ~/.bashrc
fi

# Get MITgcm code, if needed
if [ ! -d "$modelpath/../MITgcm/install_dngoldberg" ]; then
    cd $modelpath/../MITgcm
    source install_dngoldberg.sh
    cd $modelpath
fi

# Create build directory, if needed
cd $modelpath
if [ ! -d "build" ]; then mkdir build; fi
cd build

#create MITgcm makefile for this run, if needed
if [ ! -f Makefile ]; then
    if [ $hostname == "pleiades" ]; then 
	$modelpath/../MITgcm/install_dngoldberg/tools/genmake2 -of $SLR_DIR/models/ice-ocean/configs/linux_amd64_gfortran+mpi_ice_nas -mo $modelpath/../MITgcm/install_dngoldberg/verification/shelfice_remeshing/code -rd $modelpath/../MITgcm/install_dngoldberg
    else
	$modelpath/../MITgcm/install_dngoldberg/tools/genmake2 -mpi -mo $modelpath/../MITgcm/install_dngoldberg/verification/shelfice_remeshing/code -rd $modelpath/../MITgcm/install_dngoldberg
    fi
fi

#create MITgcm code links for this run, if needed
if [ ! -f BUILD_INFO.h ]; then
    make depend
fi

make -j 4
