from fielddisplay import fielddisplay
from project3d import project3d
from checkfield import checkfield
from WriteData import WriteData


class friction(object):
    """
    FRICTION class definition

       Usage:
          friction=friction()
    """

    def __init__(self):  # {{{
        self.coefficient = float('NaN')
        self.p = float('NaN')
        self.q = float('NaN')
        self.coupling = 0
        self.effective_pressure = float('NaN')
        #set defaults
        self.setdefaultparameters()
    #}}}

    def __repr__(self):  # {{{
        string = "Basal shear stress parameters: Sigma_b = coefficient^2 * Neff ^r * |u_b|^(s-1) * u_b,\n(effective stress Neff=rho_ice*g*thickness+rho_water*g*base, r=q/p and s=1/p)"

        string = "%s\n%s" % (string, fielddisplay(self, "coefficient", "friction coefficient [SI]"))
        string = "%s\n%s" % (string, fielddisplay(self, "p", "p exponent"))
        string = "%s\n%s" % (string, fielddisplay(self, "q", "q exponent"))
        string = "%s\n%s" % (string, fielddisplay(self, 'coupling', 'Coupling flag 0: uniform sheet (negative pressure ok, default), 1: ice pressure only, 2: water pressure assuming uniform sheet (no negative pressure), 3: use provided effective_pressure, 4: used coupled model (not implemented yet)'))
        string = "%s\n%s" % (string, fielddisplay(self, 'effective_pressure', 'Effective Pressure for the forcing if not coupled [Pa]'))
        return string
    #}}}

    def extrude(self, md):  # {{{
        self.coefficient = project3d(md, 'vector', self.coefficient, 'type', 'node', 'layer', 1)
        self.p = project3d(md, 'vector', self.p, 'type', 'element')
        self.q = project3d(md, 'vector', self.q, 'type', 'element')
        #if self.coupling==0: #doesnt work with empty loop, so just skip it?
        if self.coupling in[3, 4]:
            self.effective_pressure = project3d(md, 'vector', self.effective_pressure, 'type', 'node', 'layer', 1)
        elif self.coupling > 4:
            raise ValueError('md.friction.coupling larger than 4, not supported yet')
        return self
    #}}}

    def setdefaultparameters(self):  # {{{
        return self
    #}}}

    def checkconsistency(self, md, solution, analyses):  # {{{

        #Early return
        if 'StressbalanceAnalysis' not in analyses and 'ThermalAnalysis' not in analyses:
            return md

        md = checkfield(md, 'fieldname', 'friction.coefficient', 'timeseries', 1, 'NaN', 1, 'Inf', 1)
        md = checkfield(md, 'fieldname', 'friction.q', 'NaN', 1, 'Inf', 1, 'size', [md.mesh.numberofelements])
        md = checkfield(md, 'fieldname', 'friction.p', 'NaN', 1, 'Inf', 1, 'size', [md.mesh.numberofelements])
        md = checkfield(md, 'fieldname', 'friction.coupling', 'numel', [1], 'values', [0, 1, 2, 3, 4])
        if self.coupling == 3:
            md = checkfield(md, 'fieldname', 'friction.effective_pressure', 'NaN', 1, 'Inf', 1, 'timeseries', 1)
        elif self.coupling > 4:
            raise ValueError('md.friction.coupling larger than 4,  not supported yet')
        return md
    # }}}

    def marshall(self, prefix, md, fid):  # {{{
        WriteData(fid, prefix, 'name', 'md.friction.law', 'data', 1, 'format', 'Integer')
        WriteData(fid, prefix, 'object', self, 'fieldname', 'coefficient', 'format', 'DoubleMat', 'mattype', 1)
        WriteData(fid, prefix, 'object', self, 'fieldname', 'p', 'format', 'DoubleMat', 'mattype', 2)
        WriteData(fid, prefix, 'object', self, 'fieldname', 'q', 'format', 'DoubleMat', 'mattype', 2)
        WriteData(fid, prefix, 'class', 'friction', 'object', self, 'fieldname', 'coupling', 'format', 'Integer')
        if self.coupling in[3, 4]:
            WriteData(fid, prefix, 'class', 'friction', 'object', self, 'fieldname', 'effective_pressure', 'format', 'DoubleMat', 'mattype', 1, 'timeserieslength', md.mesh.numberofvertices + 1, 'yts', md.constants.yts)
        elif self.coupling > 4:
            raise ValueError('md.friction.coupling larger than 4,  not supported yet')
    # }}}
