#Test Name: GiaIvinsBenchmarksAB2dD2
import numpy as np
from model import *
from socket import gethostname
from solve import *
from triangle import *
from setmask import *
from parameterize import *

#Benchmark experiments (Figure A2c Ivins and James, 1999, Geophys. J. Int.)
md = triangle(model(), '../Exp/RoundFrontEISMINT.exp', 200000)
md = setmask(md, '', '')
md = parameterize(md, '../Par/GiaIvinsBenchmarksCD.py')

#indicate what you want to compute
md.gia.cross_section_shape = 2  # for square-edged x-section

#define loading history
md.timestepping.start_time = 1000.3  # for t \approx 1 kyr
md.timestepping.final_time = 2500000  # 2, 500 kyr
md.geometry.thickness = np.array([np.append(md.geometry.thickness * 0.0, 0.0),
                                  np.append(md.geometry.thickness / 2.0, 0.1),
                                  np.append(md.geometry.thickness, 0.2),
                                  np.append(md.geometry.thickness, md.timestepping.start_time)]).T

#solve for GIA deflection
md.cluster = generic('name', gethostname(), 'np', 3)
md.verbose = verbose('1111111')
md = solve(md, 'Gia')

#Fields and tolerances to track changes
field_names = ['GiaW', 'GiadWdt']
field_tolerances = [1e-13, 1e-13]
field_values = [md.results.GiaSolution.GiaW, md.results.GiaSolution.GiadWdt]
