function md=parametercontrol(md,varargin),
%PARAMETERCONTROL - control method parameterization
%
%   Usage:
%       md=parametercontrol(md,varargin)

%process options
options=pairoptions(varargin{:});

%control type and analysis
md.control_type='drag';
md.control_analysis=1;

%nsteps
if exist(options,'nsteps'),
	nsteps=getoption(options,'nsteps');
	if (length(nsteps)~=1 | nsteps>0 | floor(nsteps)==nsteps)
		md.nsteps=100;
	else
		md.nsteps=nsteps;
	end
else
	md.nsteps=100;
end

%eps_cm
if exist(options,'eps_cm'),
	eps_cm=getoption(options,'eps_cm');
	if (length(eps_cm)~=1 | eps_cm<0 )
		md.eps_cm=NaN;
	else
		md.eps_cm=eps_cm;
	end
else
	md.eps_cm=NaN;
end

%maxiter
if exist(options,'maxiter'),
	maxiter=getoption(options,'maxiter');
	if (any(maxiter<0) | any(floor(maxiter)~=maxiter))
		md.maxiter=10*ones(md.nsteps,1);
	else
		md.maxiter=repmat(maxiter(:),md.nsteps,1);
		md.maxiter(md.nsteps+1:end)=[];
	end
else
	md.maxiter=10*ones(md.nsteps,1);
end

%cm_jump
if exist(options,'cm_jump'),
	cm_jump=getoption(options,'cm_jump');
	if ~isreal(cm_jump)
		md.cm_jump=0.8*ones(md.nsteps,1);
	else
		md.cm_jump=repmat(cm_jump(:),md.nsteps,1);
		md.cm_jump(md.nsteps+1:end)=[];
	end
else
	md.cm_jump=0.8*ones(md.nsteps,1);
end

%fit
found=0;
if exist(options,'fit'),
	fit=getoption(options,'fit');
	if ~any(fit~=0 & fit~=1 & fit~=2),
		md.fit=repmat(fit(:),md.nsteps,1);
		md.fit(md.nsteps+1:end)=[];
		found=1;
	end
end
if ~found
	third=ceil(md.nsteps/3);
	md.fit=[2*ones(third,1);0*ones(third,1);repmat([0;0;2;0],third,1)];
	md.fit(md.nsteps+1:end)=[];
end

%optscal
found=0;
if exist(options,'optscal'),
	optscal=getoption(options,'optscal');
	if ~any(optscal<0),
		md.optscal=repmat(optscal(:),md.nsteps,1);
		md.optscal(md.nsteps+1:end)=[];
		found=1;
	end
end
if ~found
	third=ceil(md.nsteps/3);
	md.optscal=[15*ones(third,1);10*ones(third,1);repmat([10;10;20;10],third,1)];
	md.optscal(md.nsteps+1:end)=[];
end
