function options=buildlist(options,varargin),
%BUILDLIST - build list of options from input
%
%   Usage:
%      options=buildlist(options,varargin)

%check length of input
if mod((nargin-1),2),
	error('buildlist error message: an even number of options is required')
end

%go through varargin and build list of options
for i=1:(nargin-1)/2,
	if ischar(varargin{2*i-1}),
		options.list{end+1,1}=varargin{2*i-1};
		options.list{end,2}=varargin{2*i};
	else
		%option is not a string, ignore it
		disp(['pairoptions info: option number ' num2str(i) ' is not a string, it will be ignored']);
		continue
	end
end
