function value=getoption(pairoptions,optioname),
%GETOPTION - get the value of an option
%
%   Usage:
%      value=getoption(pairoptions,optioname)

%some argument checking: 
if ((nargin~=2) | (nargout~=1)),
	help getoption
	error('getoption error message: bad usage');
end

if ~ischar(optioname),
	error('getoption error message: optioname should be a string');
end

%Recover option
value='option not found';
for i=1:size(pairoptions.list,1),
	if strcmpi(pairoptions.list{i,1},optioname)
		value=pairoptions.list{i,2};
		return
	end
end
