import numpy as np
#from vlist_write import *
from MatlabArray import *

class uniform_uncertain(object):
	'''
  definition for the uniform_uncertain class.

  [uuv] = uniform_uncertain.uniform_uncertain(args)
   uuv  = uniform_uncertain()

  where the required args are:
    descriptor    (str, description, '')
    lower         (float, lower bound, -np.Inf)
    upper         (float, upper bound,  np.Inf)

  note that zero arguments constructs a default instance, one
  argument of the class copies the instance, and three or more
  arguments constructs a new instance from the arguments.
'''

	def __init__(self):
		self.descriptor = ''
		self.lower      = -np.Inf
		self.upper      =  np.Inf

	@staticmethod
	def uniform_uncertain(*args):
		nargin = len(args)

		# create a default object
		if nargin == 0:
			return uniform_uncertain()

		# copy the object
		elif nargin == 1:
			if isinstance(args[0],uniform_uncertain):
				uuv = args[0]
			else:
				raise RuntimeError('Object '+str(args[0])+' is a '+str(type(args[0]))+' class object, not "uniform_uncertain".')

		# not enough arguments
		elif nargin == 2:
			raise RuntimeError('Construction of "uniform_uncertain" class object requires at least 3 inputs.')

		# create the object from the input
		else:
			# leaving this here in case it becomes important in the future
			#asizec=array_size(*args[0:min(nargin,3)])
			#uuv = [uniform_uncertain() for i in range(asizec[0]) for j in range(asizec[1])]
			uuv = uniform_uncertain()
			uuv.descriptor = str(args[0])
			uuv.lower      = args[1]
			uuv.upper      = args[2]
		if (nargin > 3):
			print('WARNING: uniform_uncertain:extra_arg: Extra arguments for object of class '+type(uuv)+'.')

		return [uuv]

	def __repr__(self):
		# display an individual object
		string = '\n'
		string += 'class "uniform_uncertain" object = \n'
		string += '    descriptor: ' + str(self.descriptor) + '\n'
		string += '         lower: ' + str(self.lower) + '\n'
		string += '         upper: ' + str(self.upper) + '\n'

		return string

	# from here on, uuv is either a single, or a 1d vector of, uniform_uncertain

	@staticmethod
	def prop_desc(uuv,dstr):
		if type(uuv) not in [list,np.ndarray]:
			if uuv.descriptor != '' or type(uuv.descriptor) != str:
				desc = str(uuv.descriptor)
			elif dstr != '':
				desc = str(dstr)
			else:
				desc = 'uuv'
			return desc

		desc = ['' for i in range(np.size(uuv))]
		for i in range(np.size(uuv)):
			if uuv[i].descriptor != '' or type(uuv[i].descriptor) != str:
				desc[i] = str(uuv[i].descriptor)
			elif dstr != '':
				desc[i] = str(dstr)+str(string_dim(uuv,i,'vector'))
			else:
				desc[i] = 'uuv'+str(string_dim(uuv,i,'vector'))

			desc = allempty(desc)

		return desc

	@staticmethod
	def prop_initpt(uuv):
		initpt=[]
		return initpt

	@staticmethod
	def prop_lower(uuv):
		if type(uuv) not in [list,np.ndarray]:
			return uuv.lower

		lower = np.zeros(np.size(uuv))
		for i in range(np.size(uuv)):
			lower[i] = uuv[i].lower

		lower = allequal(lower,-np.Inf)

		return lower

	@staticmethod
	def prop_upper(uuv):
		if type(uuv) not in [list,np.ndarray]:
			return uuv.upper

		upper = np.zeros(np.size(uuv))
		for i in range(np.size(uuv)):
			upper[i] = uuv[i].upper

		upper = allequal(upper, np.Inf)

		return upper

	@staticmethod
	def prop_mean(uuv):
		mean=[]
		return mean

	@staticmethod
	def prop_stddev(uuv):
		stddev=[]
		return stddev

	@staticmethod
	def prop_initst(uuv):
		initst=[]
		return initst

	@staticmethod
	def prop_stype(uuv):
		stype=[]
		return stype

	@staticmethod
	def prop_scale(uuv):
		scale=[]
		return scale

	@staticmethod
	def dakota_write(fidi,dvar):
		# collect only the variables of the appropriate class
		uuv = [struc_class(i,'uniform_uncertain','uuv') for i in dvar]
		# possible namespace pollution, the above import seems not to work
		from vlist_write import vlist_write
		# write variables
		vlist_write(fidi,'uniform_uncertain','uuv',uuv)
