import numpy as np
#from vlist_write import *
from MatlabArray import *

class normal_uncertain(object):
	'''
  definition for the normal_uncertain class.

  [nuv] = normal_uncertain.normal_uncertain(args)
   nuv  = normal_uncertain()

  where the required args are:
    descriptor    (str, description, '')
    mean          (float, mean, float('NaN'))
    stddev        (float, standard deviation, float('NaN'))
  and the optional args and defaults are:
    lower         (float, lower bound, -np.Inf)
    upper         (float, upper bound,  np.Inf)

  note that zero arguments constructs a default instance, one
  argument of the class copies the instance, and three or more
  arguments constructs a new instance from the arguments.
'''
	def __init__(self):
		self.descriptor = ''
		self.mean       = float('NaN')
		self.stddev     = float('NaN')
		self.lower      =-np.Inf
		self.upper      = np.Inf

	@staticmethod
	def normal_uncertain(*args):
		nargin = len(args)

		# create a default object
		if nargin == 0:
			return normal_uncertain()

		# copy the object
		elif nargin == 1:
			if isinstance(args[0],normal_uncertain):
				nuv = args[0]
			else:
				raise RuntimeError('Object '+str(args[0])+' is a '+str(type(args[0]))+' class object, not "normal_uncertain".')

		# not enough arguments
		elif nargin == 2:
			raise RuntimeError('Construction of "normal_uncertain" class object requires at least 3 inputs.')

		# create the object from the input
		else:
			# lines differ here in other classes/tests; see asizec problem in notes
			nuv=normal_uncertain()
			nuv.descriptor = str(args[0])
			nuv.mean   = args[1]
			nuv.stddev = args[2]
			if nargin >= 4:
				nuv.lower = args[3]
			if nargin >= 5:
				nuv.upper = args[4]
			if nargin > 5:
				print('WARNING: normal_uncertain:extra_arg: Extra arguments for object of class '+str(type(nuv))+'.')

		return [nuv]

	def __repr__(self):
		# display an individual object
		string = '\n'
		string += 'class "normal_uncertain" object = \n'
		string += '    descriptor: '+str(self.descriptor) + '\n'
		string += '          mean: '+str(self.mean) + '\n'
		string += '        stddev: '+str(self.stddev) + '\n'
		string += '         lower: '+str(self.lower) + '\n'
		string += '         upper: '+str(self.upper) + '\n'

		return string

	# from here on, nuv is either a single, or a 1d vector of, normal_uncertain

	@staticmethod
	def prop_desc(nuv,dstr):
		if type(nuv) not in [list,np.ndarray]:
			if nuv.descriptor != '' or type(nuv.descriptor) != str:
				desc = str(nuv.descriptor)
			elif dstr != '':
				desc = str(dstr)
			else:
				desc = 'nuv'
			return desc

		desc = ['' for i in range(np.size(nuv))]
		for i in range(np.size(nuv)):
			if nuv[i].descriptor != '' or type(nuv[i].descriptor) != str:
				desc[i] = str(nuv[i].descriptor)
			elif dstr != '':
				desc[i] = str(dstr)+str(string_dim(nuv,i,'vector'))
			else:
				desc[i] = 'nuv'+str(string_dim(nuv,i,'vector'))

		desc = allempty(desc)

		return desc

	@staticmethod
	def prop_initpt(nuv):
		initpt=[]
		return initpt

	@staticmethod
	def prop_lower(nuv):
		if type(nuv) not in [list,np.ndarray]:
			return nuv.lower

		lower = np.zeros(np.size(nuv))
		for i in range(np.size(nuv)):
			lower[i] = nuv[i].lower

		lower = allequal(lower,-np.inf)

		return lower

	@staticmethod
	def prop_upper(nuv):
		if type(nuv) not in [list,np.ndarray]:
			return nuv.upper

		upper = np.zeros(np.size(nuv))
		for i in range(np.size(nuv)):
			upper[i] = nuv[i].upper

		upper = allequal(upper,-np.inf)
		return upper

	@staticmethod
	def prop_mean(nuv):
		if type(nuv) not in [list,np.ndarray]:
			return nuv.mean

		mean = np.zeros(np.size(nuv))
		for i in range(np.size(nuv)):
			mean[i] = nuv[i].mean

		return mean

	@staticmethod
	def prop_stddev(nuv):
		if type(nuv) not in [list,np.ndarray]:
			return nuv.stddev

		stddev = np.zeros(np.size(nuv))
		for i in range(np.size(nuv)):
			stddev[i] = nuv[i].stddev

		return stddev

	@staticmethod
	def prop_initst(nuv):
		initst=[]
		return initst

	@staticmethod
	def prop_stype(nuv):
		stype=[]
		return stype

	@staticmethod
	def prop_scale(nuv):
		scale=[]
		return scale

	@staticmethod
	def dakota_write(fidi,dvar):
		# collect only the variables of the appropriate class
		nuv = [struc_class(i,'normal_uncertain','nuv') for i in dvar]

		# possible namespace pollution, the above import seems not to work
		from vlist_write import vlist_write
		# write variables
		vlist_write(fidi,'normal_uncertain','nuv',nuv)
