#! /usr/bin/env python
from IdToName import IdToName
import os

# use verbose=False to print output when this is called by command line
def IdFromString(string,verbose=False):
	"""
	IDFROMSTRING - output ids from a given string
 
	    Usage:
		ids=IdFromString(string)
 
	    Examples:
		ids=IdFromString('Parallel')
		ids=IdFromString('79North')
		ids=IdFromString('*')
	"""

	#Check input
	if not isinstance(string,str):
		raise TypeError('IdFromString error message: input argument is not a string.')
	string = string.replace("'",'')
	string = string.replace('"','')

	#Get the test ids and names and scan for matches

	ids = []
	idnames = []
	for f in os.listdir('.'):
		if f.endswith('.py') and f.startswith('test'):
			# all tests look like: "testwxyz.py" so 5th to 3rd to last is always the full id
			s = int(f[4:-3])
			name = IdToName(s)
			if (string == '*') or (name != None and string in name):
				ids.append(s)
				idnames.append(name)

	#Return if no test found
	if not ids:
		print("No test matches '%s'." % string)
		return ids

	#Display names
	if verbose:
		idnames = [i for _,i in sorted(zip(ids,idnames), key=lambda pair: pair[0])]

	ids.sort()

	if verbose:
		print("%s tests match '%s':" % (len(ids),string))
		for i in range(len(ids)):
			print("   %s : %s" % (ids[i],idnames[i]))
	#else:
		#print ids

	return ids

