%Test Name: PigTranCalvingDevHO3d
md=triangle(model(),'../Exp/Pig.exp',10000.);
md=setmask(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,5,1);
md=setflowequation(md,'HO','all');
md.timestepping.time_step=2;
md.timestepping.final_time=50;

%calving parameters
md.mask.ice_levelset = 1e4*(md.mask.ice_levelset + 0.5);
md.calving=calvingvonmises();
md.frontalforcings.meltingrate = zeros(md.mesh.numberofvertices,1);
md.transient.ismovingfront = 1;
md.levelset.spclevelset = NaN(md.mesh.numberofvertices,1);
pos = find(md.mesh.vertexonboundary);
md.levelset.spclevelset(pos) = md.mask.ice_levelset(pos);

%Force MUMPS sequential analysis
md.toolkits.DefaultAnalysis.mat_mumps_icntl_28=1;
md.cluster=generic('name',oshostname(),'np',2);
md=solve(md,'Transient');

%Fields and tolerances to track changes
field_names ={...
	'Vx1' ,'Vy1' ,'Vel1' ,'Pressure1' ,'Bed1' ,'Surface1' ,'Thickness1' ,'MaskIceLevelset1' ,...
	'Vx2' ,'Vy2' ,'Vel2' ,'Pressure2' ,'Bed2' ,'Surface2' ,'Thickness2' ,'MaskIceLevelset2' ,...
	'Vx10','Vy10','Vel10','Pressure10','Bed10','Surface10','Thickness10','MaskIceLevelset10',...
	};
field_tolerances={...
	1e-11,2e-11,2e-11,1e-12,5e-12,2e-12,4e-12,1e-12,...
	1e-11,1e-11,1e-11,4e-12,6e-12,1e-11,5e-12,1e-11,...
	2e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-9,...
	};
field_values={...
	(md.results.TransientSolution(1).Vx),...
	(md.results.TransientSolution(1).Vy),...
	(md.results.TransientSolution(1).Vel),...
	(md.results.TransientSolution(1).Pressure),...
	(md.results.TransientSolution(1).Base),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).MaskIceLevelset),...
	(md.results.TransientSolution(2).Vx),...
	(md.results.TransientSolution(2).Vy),...
	(md.results.TransientSolution(2).Vel),...
	(md.results.TransientSolution(2).Pressure),...
	(md.results.TransientSolution(2).Base),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(2).MaskIceLevelset),...
	(md.results.TransientSolution(10).Vx),...
	(md.results.TransientSolution(10).Vy),...
	(md.results.TransientSolution(10).Vel),...
	(md.results.TransientSolution(10).Pressure),...
	(md.results.TransientSolution(10).Base),...
	(md.results.TransientSolution(10).Surface),...
	(md.results.TransientSolution(10).Thickness),...
	(md.results.TransientSolution(10).MaskIceLevelset),...
	};
