from uniform_uncertain import uniform_uncertain
from normal_uncertain import normal_uncertain
from copy import deepcopy

def QmuSetupVariables(md,dvar,variables):

	#get descriptor
	descriptor=variables.descriptor

	#decide whether this is a distributed variable, which will drive whether we expand it into npart values,
	#or if we just carry it forward as is.

	#ok, key off according to type of descriptor:
	if strncmp(descriptor,'scaled_',7):
		#we have a scaled variable, expand it over the partition.

		if isinstance(variables,uniform_uncertain):
			if ((type(variables.lower) in [list,np.ndarray] and len(variables.lower) > md.qmu.numberofpartitions) or (type(variables.upper) in [list,np.ndarray] and len(variables.upper) > md.qmu.numberofpartitions)):
				raise RuntimeError('QmuSetupDesign error message: upper and lower should be either a scalar or a "npart" length vector')

		elif isinstance(variables,normal_uncertain):
			if type(variables.stddev) in [list,np.ndarray] and len(variables.stddev) > md.qmu.numberofpartitions:
				raise RuntimeError('QmuSetupDesign error message: stddev should be either a scalar or a "npart" length vector')

		#ok, dealing with semi-discrete distributed variable. Distribute according to how many
		#partitions we want

		for j in range(md.qmu.numberofpartitions):
			dvar.append(deepcopy(variables))
			# "'" is because qmu.in files need for strings to be in actual ''
			# must also account for whether we are given 1 instance or an array of instances

			# handle descriptors for everything
			if type(dvar[-1].descriptor) in [list,np.ndarray] and len(variables.descriptor) > 1 and len(variables.upper) != md.qmu.numberofpartitions:
				if type(variables.descriptor) == np.ndarray:
					dvar[-1].descriptor = np.append(dvar[-1].descriptor,"'"+str(variables.descriptor)+'_'+str(j+1)+"'")
				else:
					dvar[-1].descriptor.append("'"+str(variables.descriptor)+'_'+str(j+1)+"'")
			else:
				dvar[-1].descriptor = "'"+str(variables.descriptor)+'_'+str(j+1)+"'"

			# handle uniform_uncertain
			if isinstance(variables,uniform_uncertain):
				if type(variables.lower) in [list,np.ndarray] and len(variables.lower) > 1 and len(variables.upper) != md.qmu.numberofpartitions:
					if type(variables.lower) == np.ndarray:
						dvar[-1].lower = np.append(dvar[-1].lower, variables.lower[j])
					else:
						dvar[-1].lower.append(variables.lower[j])
				else:
					dvar[-1].lower = variables.lower

				if type(variables.upper) in [list,np.ndarray] and len(variables.upper) > 1 and len(variables.upper) != md.qmu.numberofpartitions:
					if type(variables.upper) == np.ndarray:
						dvar[-1].upper = np.append(dvar[-1].upper, variables.upper[j])
					else:
						dvar[-1].upper.append(variables.upper[j])
				else:
					dvar[-1].upper = variables.upper

			# handle normal_uncertain
			elif isinstance(variables,normal_uncertain):
				if type(variables.stddev) in [list,np.ndarray] and len(variables.stddev) > 1 and len(variables.upper) != md.qmu.numberofpartitions:
					if type(variables.stddev) == np.ndarray:
						dvar[-1].stddev = np.append(dvar[-1].stddev, variables.stddev[j])
					else:
						dvar[-1].stddev.append(variables.stddev[j])
				else:
					dvar[-1].stddev = variables.stddev

	# running with a single instance, and therefore length 1 arrays of qmu classes
	else:
		dvar.append(variables)
		# text parsing in dakota requires literal "'identifier'" not just "identifier"
		for v in dvar:
			v.descriptor = "'"+str(v.descriptor)+"'"

	return dvar
