from MatlabFuncs import *
from copy import deepcopy

def QmuSetupResponses(md,dresp,responses):

	#get descriptor
	descriptor=responses.descriptor

	#decide whether this is a distributed response, which will drive whether we expand it into npart values,
	#or if we just carry it forward as is. 

	#ok, key off according to type of descriptor:
	if strncmp(descriptor,'scaled_',7):
		#we have a scaled response, expand it over the partition.
		#ok, dealing with semi-discrete distributed response. Distribute according to how many 
		#partitions we want
		for j in range(md.qmu.numberofpartitions):
			dresp.append(deepcopy(responses))
			dresp[-1].descriptor=str(responses.descriptor)+'_'+str(j+1)
	else:
		dresp.append(responses)

	return dresp
