import numpy as np
#move this later
from helpers import *
from vector_write import vector_write
from normal_uncertain import normal_uncertain

def check(a,l,p):
	'''in the event that a and b are equal, return a;
in the event that a and b are not equal, return their concatenation

	This is used for when both the input dvar and the 'cstring' variables have non-1 length
'''

	if np.size(a) == l:
		if p == 0:
			if type(a) in [list,np.ndarray]:
				return a
			else:
				return [a]
		else:
			return []
	elif np.size(a) == 1:
		if type(a) in [list,np.ndarray]:
			return a
		else:
			return [a]
	elif np.size(a) == 0:
		return []
	else:
		raise RuntimeError('ERROR vlist_write: input field had size '+str(np.size(a))+'; must have size of 0, 1, or match size of provided dvar ('+str(l)+').')

	return

def vlist_write(fidi,cstring,cstring2,dvar):
	'''
function to write variable list
'''
	if dvar == None:
		return
	func = eval(cstring)

	# put variables into lists for writing

	if type(dvar) not in [list,np.ndarray]:
		dvar = [dvar]

	# assume all fields in dvar[0:n] are consistent (ex. all are normal_uncertain)
	#   which will always be true since this vlist_write is called per field
	fnames=fieldnames(dvar[0])

	nvar=0
	pinitpt=[[] for i in range(len(fnames))]
	plower =[[] for i in range(len(fnames))]
	pupper =[[] for i in range(len(fnames))]
	pmean  =[[] for i in range(len(fnames))]
	pstddev=[[] for i in range(len(fnames))]
	pinitst=[[] for i in range(len(fnames))]
	pstype =[[] for i in range(len(fnames))]
	pscale =[[] for i in range(len(fnames))]
	pdesc  =[[] for i in range(len(fnames))]

	for i in range(len(fnames)):
		nvar += len(dvar)
		for j in dvar:
			j = vars(j)[fnames[i]]
			pinitpt[i].extend(check(func.prop_initpt(j),len(dvar),len(pinitpt[i])))
			plower[i].extend(check(func.prop_lower(j),len(dvar),len(plower[i])))
			pupper[i].extend(check(func.prop_upper(j),len(dvar),len(pupper[i])))
			pmean[i].extend(check(func.prop_mean(j),len(dvar),len(pmean[i])))
			pstddev[i].extend(check(func.prop_stddev(j),len(dvar),len(pstddev[i])))
			pinitst[i].extend(check(func.prop_initst(j),len(dvar),len(pinitst[i])))
			pstype[i].extend(check(func.prop_stype(j),len(dvar),len(pstype[i])))
			pscale[i].extend(check(func.prop_scale(j),len(dvar),len(pscale[i])))
			pdesc[i].extend(check(func.prop_desc(j,fnames[i]),len(dvar),len(pdesc[i])))

	pinitpt=allempty(pinitpt)
	plower =allempty(plower)
	pupper =allempty(pupper)
	pmean  =allempty(pmean)
	pstddev=allempty(pstddev)
	pinitst=allempty(pinitst)
	pstype =allempty(pstype)
	pscale =allempty(pscale)
	pdesc  =allempty(pdesc)

	# write variables
	print('  Writing '+str(nvar)+' '+cstring+' variables.')

	fidi.write('\t'+cstring+' = '+str(nvar)+'\n')
	if not isempty(pinitpt):
		fidi.write('\t  '+cstring2+'_initial_point =\n')
		vector_write(fidi,'\t    ',pinitpt,6,76)

	if not isempty(plower):
		fidi.write('\t  '+cstring2+'_lower_bounds =\n')
		vector_write(fidi,'\t    ',plower ,6,76)

	if not isempty(pupper):
		fidi.write('\t  '+cstring2+'_upper_bounds =\n')
		vector_write(fidi,'\t    ',pupper ,6,76)

	if not isempty(pmean):
		fidi.write('\t  '+cstring2+'_means =\n')
		vector_write(fidi,'\t    ',pmean  ,6,76)

	if not isempty(pstddev):
		fidi.write('\t  '+cstring2+'_std_deviations =\n')
		vector_write(fidi,'\t    ',pstddev,6,76)

	if not isempty(pinitst):
		fidi.write('\t  '+cstring2+'_initial_state =\n')
		vector_write(fidi,'\t    ',pinitst,6,76)

	if not isempty(pstype):
		fidi.write('\t  '+cstring2+'_scale_types =\n')
		vector_write(fidi,'\t    ',pstype ,6,76)

	if not isempty(pscale):
		fidi.write('\t  '+cstring2+'_scales =\n')
		vector_write(fidi,'\t    ',pscale ,6,76)

	if not isempty(pdesc):
		fidi.write('\t  '+cstring2+'_descriptors =\n')
		vector_write(fidi,'\t    ',pdesc  ,6,76)

	return
