from fielddisplay import fielddisplay
from project3d import project3d
from checkfield import checkfield
from WriteData import WriteData

class frontalforcings(object):
	"""
	FRONTAL FORCINGS class definition

	   Usage:
	      frontalforcings=frontalforcings();
	"""

	def __init__(self): # {{{

		self.meltingrate   = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string='   Frontalforcings parameters:'
		string="%s\n%s"%(string,fielddisplay(self,'meltingrate','melting rate at given location [m/a]'))

		return string
		#}}}
	def extrude(self,md): # {{{
		self.meltingrate=project3d(md,'vector',self.meltingrate,'type','node')
		return self
	#}}}
	def setdefaultparameters(self): # {{{

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		#Early return
                if (solution!='TransientSolution') or (not md.transient.ismovingfront):
                    return md

                md = checkfield(md,'fieldname','frontalforcings.meltingrate','NaN',1,'Inf',1,'timeseries',1,'>=',0);

		return md
	# }}}
	def marshall(self,prefix,md,fid):    # {{{

            yts=md.constants.yts

	    WriteData(fid,prefix,'name','md.frontalforcings.parameterization','data',1,'format','Integer')
            WriteData(fid,prefix,'object',self,'fieldname','meltingrate','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts,'scale',1./yts);

        # }}}
