from fielddisplay import fielddisplay
from project3d import project3d
from checkfield import checkfield
from WriteData import WriteData

class frontalforcings(object):
	"""
	FRONTAL FORCINGS class definition

	   Usage:
	      frontalforcings=frontalforcings();
	"""

	def __init__(self): # {{{

		self.meltingrate   = float('NaN')
		self.melt_parameterization   = 0.
                self.basin = float('NaN')
                self.numberofbasins = float('NaN')
                self.subglacial_discharge = float('NaN')
                self.thermalforcings = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string='   Frontalforcings parameters:'
		string="%s\n%s"%(string,fielddisplay(self,'melt_parameterization','0: no, 1: Rignot melt parameterization (Rignot et al.,2016)'))
                if self.melt_parameterization==0:
                    string="%s\n%s"%(string,fielddisplay(self,'meltingrate','melting rate at given location [m/a]'))
                elif self.melt_parameterization==1: 
                    string="%s\n%s"%(string,fielddisplay(self,'basin','basin ID for vertices'))
                    string="%s\n%s"%(string,fielddisplay(self,'numberofbasins','number of basins'))
                    string="%s\n%s"%(string,fielddisplay(self,'subglacial_discharge','sum of subglacial discharge for each basin [m/d]'))
                    string="%s\n%s"%(string,fielddisplay(self,'thermalforcing','thermal forcing [C]'))

		return string
		#}}}
	def extrude(self,md): # {{{
		self.meltingrate=project3d(md,'vector',self.meltingrate,'type','node')
		return self
	#}}}
	def setdefaultparameters(self): # {{{

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		#Early return
		if (solution!='TransientSolution') or (not md.transient.ismovingfront):
			return md
			
                md = checkfield(md,'fieldname','frontalforcings.melt_parameterization','numel',[1],'values',[0,1]);
                if self.melt_parameterization==0:
                    md = checkfield(md,'fieldname','frontalforcings.meltingrate','NaN',1,'Inf',1,'timeseries',1,'>=',0);
                elif self.melt_parameterization==1:
                    md = checkfield(md,'fieldname','frontalforcings.basin','>',0,'nan',1,'Inf',1);
                    md = checkfield(md,'fieldname','frontalforcings.numberofbasins','numel',[1]);
                    md = checkfield(md,'fieldname','frontalforcings.subglacial_discharge','>=',0,'nan',1,'Inf',1,'timeseries',1);
                    md = checkfield(md,'fieldname','frontalforcings.thermalforcing','nan',1,'Inf',1,'timeseries',1);

		return md
	# }}}
	def marshall(self,prefix,md,fid):    # {{{

		yts=md.constants.yts

                WriteData(fid,prefix,'object',self,'fieldname','melt_parameterization','format','Integer');
                if self.melt_parameterization==0:
                    WriteData(fid,prefix,'object',self,'fieldname','meltingrate','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts,'scale',1./yts);
                elif self.melt_parameterization==1:
                    WriteData(fid,prefix,'object',self,'fieldname','basin','format','DoubleMat','mattype',1);
                    WriteData(fid,prefix,'object',self,'fieldname','numberofbasins','format','Integer');
                    WriteData(fid,prefix,'object',self,'fieldname','subglacial_discharge','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1);
                    WriteData(fid,prefix,'object',self,'fieldname','thermalforcing','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1);

        # }}}
