%FRONTAL FORCINGS class definition
%
%   Usage:
%      frontalforcings=frontalforcings();

classdef frontalforcings
	properties (SetAccess=public) 
		meltingrate   = NaN;
		melt_parameterization =0;
		basin= NaN;
		numberofbasins=0;
		subglacial_discharge= NaN;
		thermalforcing=NaN;
	end
	methods
		function self = frontalforcings(varargin) % {{{
			switch nargin
				case 0
					self=setdefaultparameters(self);
				case 1
					inputstruct=varargin{1};
					list1 = properties('frontalforcings');
					list2 = fieldnames(inputstruct);
					for i=1:length(list1)
						fieldname = list1{i};
						if ismember(fieldname,list2),
							self.(fieldname) = inputstruct.(fieldname);
						end
					end
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = extrude(self,md) % {{{
			self.meltingrate=project3d(md,'vector',self.meltingrate,'type','node');
		end % }}}
		function self = setdefaultparameters(self) % {{{

			meltingrate   = NaN;
			melt_parameterization =0;
			basin=NaN;
			numberofbasins=0;
			subglacial_discharge=NaN;
			thermalforcing=NaN;
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{
			%Early return
			if (~strcmp(solution,'TransientSolution') | md.transient.ismovingfront==0), return; end
			
			md = checkfield(md,'fieldname','frontalforcings.melt_parameterization','numel',[1],'values',[0,1]);
			if self.melt_parameterization==0,
				md = checkfield(md,'fieldname','frontalforcings.meltingrate','NaN',1,'Inf',1,'timeseries',1,'>=',0);
			elseif self.melt_parameterization==1,
				md = checkfield(md,'fieldname','frontalforcings.basin','>',0,'nan',1,'Inf',1);
				md = checkfield(md,'fieldname','frontalforcings.numberofbasins','numel',[1]);
				md = checkfield(md,'fieldname','frontalforcings.subglacial_discharge','>=',0,'nan',1,'Inf',1,'timeseries',1);
				md = checkfield(md,'fieldname','frontalforcings.thermalforcing','nan',1,'Inf',1,'timeseries',1);
			end

		end % }}}
		function disp(self) % {{{
			disp(sprintf('   Frontalforcings parameters:'));
			fielddisplay(self,'melt_parameterization','0: no, 1: Rignot melt parameterization (Rignot et al.,2016)');
			if self.melt_parameterization==0,
				fielddisplay(self,'meltingrate','melting rate at given location [m/a]');
			elseif self.melt_parameterization==1,
				fielddisplay(self,'basin','basin ID for vertices');
				fielddisplay(self,'numberofbasins', 'number of basins');
				fielddisplay(self,'subglacial_discharge','sum of subglacial discharge for each basin [m/d]');
				fielddisplay(self,'thermalforcing','thermal forcing [∘C]');
			end
		end % }}}
		function marshall(self,prefix,md,fid) % {{{
			yts=md.constants.yts;
			WriteData(fid,prefix,'object',self,'fieldname','melt_parameterization','format','Integer');
			switch self.melt_parameterization
				case 0
					WriteData(fid,prefix,'object',self,'fieldname','meltingrate','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts,'scale',1./yts);
				case 1
					WriteData(fid,prefix,'object',self,'fieldname','basin','format','DoubleMat','mattype',1);
					WriteData(fid,prefix,'object',self,'fieldname','numberofbasins','format','Integer');
					WriteData(fid,prefix,'object',self,'fieldname','subglacial_discharge','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1);
					WriteData(fid,prefix,'object',self,'fieldname','thermalforcing','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1);
			end
		end % }}}
	end
end
