#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.6.3 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://issm.ess.uci.edu/files/externalpackages/petsc-lite-3.6.3.tar.gz' 'petsc-3.6.3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.6.3.tar.gz
mv petsc-3.6.3/* src/
rm -rf petsc-3.6.3

#--with-cc=icc --with-cxx=icpc --with-fc=ifort --with-f77=ifort \

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-blas-lapack-dir="/opt/intel/composer_xe_2013.5.192/mkl/lib/intel64/" \
	--with-mpi-dir="/opt/intel/impi/4.1.3/intel64/" \
	--known-mpi-shared-libraries=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch=1  \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-mumps=1 \
	--download-scalapack=1 

#prepare script to reconfigure petsc
cat > script.queue << EOF
#PBS -S /bin/bash
#PBS -l select=1:ncpus=1:mpiprocs=1 
#PBS -l walltime=1:00:00
#PBS -m e

export RUN_DIR=$ISSM_DIR/externalpackages/petsc/src/

source /usr/share/Modules/init/bash
module load intel/cluster-toolkit-2013.5.192

export PATH="$PATH:.:/opt/intel/impi/4.1.3/intel64/bin/"
export MPI_GROUP_MAX=64
cd $RUN_DIR
mpirun -np 1 ./conftest-arch-linux2-c-opt
EOF

#print instructions
echo "== Now: cd src/ "
echo "== qsub -q debugq script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
