%Test Name: ValleyGlacierLevelsetCalvingSSA2dCrevassedepth
md=triangle(model(),'../Exp/Square.exp',50000);
md=setmask(md,'','');
md=parameterize(md,'../Par/ValleyGlacierShelf.par');
md=setflowequation(md,'SSA','all');
md.timestepping.time_step=2;
md.timestepping.final_time=50;
md.cluster=generic('name',oshostname(),'np',3);

%Transient;
md.transient.isstressbalance=1;
md.transient.ismovingfront=1;
md.transient.ismasstransport=1;
md.transient.issmb=1;
md.transient.isthermal=0;
md.transient.isgroundingline=1;
md.transient.isgia=0;

md.calving=calvingcrevassedepth();
md.calving.crevasse_opening_stress=1;
md.calving.water_height=50*ones(md.mesh.numberofvertices,1);
md.calving.meltingrate=zeros(md.mesh.numberofvertices,1);
md.levelset.spclevelset=NaN(md.mesh.numberofvertices,1);
md.levelset.reinit_frequency=1;

md=solve(md,'Transient');

%Fields and tolerances to track changes
field_names ={...
	'Vx1','Vy1','Vel1','Pressure1','Thickness1','Surface1','MaskIceLevelset1'...
	'Vx2','Vy2','Vel2','Pressure2','Thickness2','Surface2','MaskIceLevelset2'...
	'Vx10','Vy10','Vel10','Pressure10','Thickness10','Surface10','MaskIceLevelset10'};
field_tolerances={...
	1e-8,1e-8,1e-8,1e-9,1e-9,1e-9,3e-9,...
	1e-8,1e-8,1e-8,1e-9,1e-9,1e-9,3e-9,...
	1e-8,1e-8,1e-8,1e-9,1e-9,1e-9,3e-9};
field_values={...
	md.results.TransientSolution(1).Vx,...
	md.results.TransientSolution(1).Vy,...
	md.results.TransientSolution(1).Vel,...
	md.results.TransientSolution(1).Pressure,...
	md.results.TransientSolution(1).Thickness,...
	md.results.TransientSolution(1).Surface,...
	md.results.TransientSolution(1).MaskIceLevelset,...
	md.results.TransientSolution(2).Vx,...
	md.results.TransientSolution(2).Vy,...
	md.results.TransientSolution(2).Vel,...
	md.results.TransientSolution(2).Pressure,...
	md.results.TransientSolution(2).Thickness,...
	md.results.TransientSolution(2).Surface,...
	md.results.TransientSolution(2).MaskIceLevelset,...
	md.results.TransientSolution(10).Vx,...
	md.results.TransientSolution(10).Vy,...
	md.results.TransientSolution(10).Vel,...
	md.results.TransientSolution(10).Pressure,...
	md.results.TransientSolution(10).Thickness,...
	md.results.TransientSolution(10).Surface,...
	md.results.TransientSolution(10).MaskIceLevelset,...
	};
