/*!\file VecMergex
 * \brief: merge one vector into another
 */

#include "./VecMergex.h"

#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
void VecMergex(Vector<IssmDouble>* ug, Vector<IssmDouble>* uf, Nodes* nodes, Parameters* parameters, int SetEnum){

	/*serialize uf: */
	IssmDouble* uf_serial=uf->ToMPISerial();

	/*Do we have any nodes for this configuration? :*/
	if(nodes->NumberOfNodes()){ 

		/*yes. Go through all nodes, and ask them to retrieve values from uf, and plug them into ug: */
		for(int i=0;i<nodes->Size();i++){
			Node* node=(Node*)nodes->GetObjectByOffset(i);

			/*For this object, merge values for enum set SetEnum: */
			node->VecMerge(ug,uf_serial,SetEnum);
		}
	}

	/*Free ressources:*/
	xDelete<IssmDouble>(uf_serial);

	/*Assemble vector: */
	ug->Assemble();
}
