#ifndef _CONTAINER_NODES_H_
#define  _CONTAINER_NODES_H_

#include "../datastructures/datastructures.h"
class Parameters;
class Elements;
class Vertices;
class Loads;
class Nodes;
class Materials;

/*!\brief Declaration of Nodes class.
 *
 * Declaration of Nodes class.  Nodes are vector lists of objects (Containers) of Node objects.
 * Node objects are the degrees of freedom (DOFs) for a particular analysis type (not to be 
 * confused with a vertex, which defines the (x,y,z) location of a point).
 */ 
class Nodes: public DataSet{

	public:
		int*  common_recv;
		int** common_recv_ids;
		int*  common_send;
		int** common_send_ids;

		/*constructors, destructors*/
		Nodes();
		~Nodes();

		/*Objects virtual functions*/
		Nodes* Copy();
		void Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction);

		/*numerics*/
		void  DistributeDofs(int SETENUM);
		int   MaxNumDofs(int setenum);
		int   NumberOfDofs(int setenum);
		int   NumberOfDofsLocal(int setenum);
		int   NumberOfNodes(void);
		bool  RequiresDofReindexing(void);
};

#endif //ifndef _NODES_H_
