/*! \file Numpar.h 
 *  \brief: header file for numpar object
 */

#ifndef _NUMPAR_H_
#define _NUMPAR_H_

#include "./Object.h"

class Numpar: public Object{

	private: 
		int    id;
	
	public:

		/*parameters are made public, as they will be accessed quite often: */
		double meanvel;
		double epsvel;
		int    artdiff;
		double viscosity_overshoot;
		double stokesreconditioning;
		char*  control_type;
		double cm_noisedmp;
		double cm_mindmp_value;
		double cm_mindmp_slope;
		double cm_maxdmp_value;
		double cm_maxdmp_slope;

		Numpar();
		Numpar(int id);
		~Numpar();

		/*object derived functionality: */
		void  Echo();
		void  DeepEcho();
		int   GetId(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();

		void  Configure(void* pparametersin);
		void  UpdateFromInputs(void* vinputs);
};
#endif  /* _NUMPAR_H */
