#!/bin/bash
set -eu

#Some cleanup
rm -rf install src
mkdir install

#Download latest version
git clone https://github.com/mkrapp/semic.git src

if which ifort >/dev/null; then
        FC="ifort"
        FFLAGS="-traceback -check all" #-O2 is default 
else
        FC="gfortran"
        if [ `uname` == "Darwin" ]; then
                FC="gfortran -arch x86_64"
                FFLAGS="-fcheck=all"
        fi
fi

#Compile semic module utils.f90
cd src/
(
cat << EOF
LIB_EXT=a
FC=$FC
FFLAGS=$FFLAGS
install: libutils.\$(LIB_EXT)
	cp libutils.\$(LIB_EXT) ../install/
OBJECTS= utils.o
libutils.\$(LIB_EXT): \$(OBJECTS)
	ar -r libutils.\$(LIB_EXT) \$(OBJECTS) 
	ranlib libutils.\$(LIB_EXT) 
%.o: %.f90
	\$(FC) \$(FFLAGS) -fPIC -c $< -o \$@
clean: 
	rm -rf *.o *.\$(LIB_EXT)
EOF
) > Makefile
make

#Compile semic module surface_physics.f90
(
cat << EOF
LIB_EXT=a
FC=$FC
FFLAGS=$FFLAGS
install: libsurface_physics.\$(LIB_EXT)
	cp libsurface_physics.\$(LIB_EXT) ../install/
OBJECTS= surface_physics.o
libsurface_physics.\$(LIB_EXT): \$(OBJECTS)
	ar -r libsurface_physics.\$(LIB_EXT) \$(OBJECTS) 
	ranlib libsurface_physics.\$(LIB_EXT) 
%.o: %.f90
	\$(FC) \$(FFLAGS) -fPIC -c $< -o \$@
clean: 
	rm -rf *.o *.\$(LIB_EXT)
EOF
) > Makefile
make