#!/bin/bash
set -eu

# Constants
DAK_VER="6.2"

# Some cleanup
rm -rf build
rm -rf install
rm -rf tests
rm -rf src
mkdir build install src

# Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/dakota-${DAK_VER}-public.src.tar.gz" "dakota-${DAK_VER}-public-src.tar.gz"

# Untar
tar -zxvf dakota-${DAK_VER}-public-src.tar.gz

# Move Dakota to src directory
mv dakota-${DAK_VER}.0.src/* src
rm -rf dakota-${DAK_VER}.0.src

# Set up Dakota and CMake variables
DAK_PATH=$ISSM_DIR/externalpackages/dakota

export DAK_BUILD=$DAK_PATH/build
export DAK_INSTALL=$DAK_PATH/install
export DAK_SRC=$DAK_PATH/src
export MPIHOME=$ISSM_DIR/externalpackages/mpich/install
export BOOST_ROOT=$ISSM_DIR/externalpackages/boost/install

# Apply patches
cp $DAK_SRC/cmake/BuildDakotaTemplate.cmake $DAK_SRC/cmake/BuildDakotaCustom.cmake
patch $DAK_SRC/cmake/BuildDakotaCustom.cmake configs/$DAK_VER/BuildDakotaCustom.cmake.mac.patch
patch $DAK_SRC/cmake/DakotaDev.cmake configs/$DAK_VER/DakotaDev.cmake.patch
patch $DAK_SRC/cmake/InstallDarwinDylibs.cmake configs/$DAK_VER/InstallDarwinDylibs.cmake.patch
patch $DAK_SRC/CMakeLists.txt configs/$DAK_VER/CMakeLists.txt.patch
patch src/src/NonDSampling.cpp configs/$DAK_VER/NonDSampling.cpp.patch
patch src/src/NonDLocalReliability.cpp configs/$DAK_VER/NonDLocalReliability.cpp.patch
patch src/packages/pecos/src/pecos_global_defs.hpp configs/$DAK_VER/pecos_global_defs.hpp.patch

# Configure and build Dakota
cd $DAK_BUILD
cmake \
	-C$DAK_SRC/cmake/BuildDakotaCustom.cmake \
	-C$DAK_SRC/cmake/DakotaDev.cmake \
	-DBOOST_ROOT:PATHNAME=$BOOST_ROOT \
	-DBoost_NO_BOOST_CMAKE=TRUE \
	-DBoost_NO_SYSTEM_PATHS=TRUE \
	-DBoost_LIBRARY_DIRS:FILEPATH=$BOOST_ROOT/lib \
	-DCMAKE_INSTALL_PREFIX=$DAK_INSTALL \
	-DCMAKE_C_COMPILER=$ISSM_DIR/externalpackages/mpich/install/bin/mpicc \
	-DCMAKE_CXX_COMPILER=$ISSM_DIR/externalpackages/mpich/install/bin/mpicxx \
	-DCMAKE_Fortran_COMPILER=$ISSM_DIR/externalpackages/mpich/install/bin/mpif77 \
	-DCMAKE_CXX_FLAGS=-fdelayed-template-parsing \
	-DHAVE_ACRO=off \
	-DHAVE_JEGA=off \
	$DAK_SRC

if [ $# -eq 0 ];
then
	make
	make install
else
	make -j $1
	make -j $1 install
fi

# Set paths and library paths
export PATH=$DAK_INSTALL/bin:$DAK_INSTALL/test:$PATH

if [ -z $DYLD_LIBRARY_PATH ]
then
	export DYLD_LIBRARY_PATH=$DAK_INSTALL/lib:$DAK_INSTALL/bin
else
	export DYLD_LIBRARY_PATH=$DAK_INSTALL/lib:$DAK_INSTALL/bin:$DYLD_LIBRARY_PATH
fi
