#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.5.1 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-lite-3.5.1.tar.gz' 'petsc-3.5.1.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.5.1.tar.gz
mv petsc-3.5.1/* src/
rm -rf petsc-3.5.1

#configure
cd src
./config/configure.py \
  --prefix="$ISSM_DIR/externalpackages/petsc/install" \
  --PETSC_ARCH="$ISSM_ARCH" \
  --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
  --with-batch=1  \
  --with-debugging=0 \
  --with-shared-libraries=1 \
  --known-mpi-shared-libraries=1 \
  --with-mpi=1 \
  --with-mpi-lib="/nasa/sgi/mpt/2.06rp16/lib/libmpi.so" \
  --with-mpi-include="/nasa/sgi/mpt/2.06rp16/include" \
  --with-blas-lapack-dir="/nasa/intel/Compiler/2012.0.032/composer_xe_2011_sp1/mkl/lib/intel64" \
  --download-scalapack=yes \
  --download-mumps=yes \
  --download-metis=yes \
  --download-parmetis=yes \
  --download-trilinos=yes \
  --download-euclid=yes \
  --download-hypre=yes \
  --COPTFLAGS="-lmpi -O3" \
  --FOPTFLAGS="-lmpi -O3" \
  --CXXOPTFLAGS="-lmpi -O3"

#prepare script to reconfigure petsc
cat > script.queue << EOF
#PBS -S /bin/bash
#PBS -l select=1:ncpus=1:model=wes 
#PBS -l walltime=200 
#PBS -W group_list=s1010
#PBS -m e 

. /usr/share/modules/init/bash 
module load comp-intel/2012.0.032
module load math/intel_mkl_64_10.0.011
module load mpi-sgi/mpt.2.06rp16

export PATH="$PATH:." 
export MPI_GROUP_MAX=64 
mpiexec -np 1 ./conftest-linux-gnu-ia64-intel.py
EOF

#print instructions
echo "== Now: cd src/ "
echo "== qsub -q devel script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
