#!/bin/bash
set -eu

GDAL_VER="1.10.0"

# Some cleanup
rm -rf src
rm -rf install
rm -rf gdal-${GDAL_VER}
mkdir src install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'http://issm.jpl.nasa.gov/files/externalpackages/gdal-${GDAL_VER}.tar.gz' 'gdal-${GDAL_VER}.tar.gz'

# Untar
tar -zxvf gdal-${GDAL_VER}.tar.gz

# Move gdal into src directory
mv gdal-${GDAL_VER}/* src
rm -rf gdal-${GDAL_VER}

# Configure gdal
cd src
./configure \
	--prefix="$ISSM_DIR/externalpackages/gdal/install" \
	--with-python \
	--with-netcdf=no \
	--with-libiconv-prefix="/usr/lib/" \
	--without-hdf5 \
	--with-expat=$ISSM_DIR/externalpackages/expat/install
#Note:
# look for libiconv in /usr/lib/ because there seemed to be a conflict with port's library

#Compile and install gdal
if [ $# -eq 0 ]; then
	make
else
	make -j $1
fi
make install
