#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.4.3 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-lite-3.4.3.tar.gz' 'petsc-3.4.3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.4.3.tar.gz
mv petsc-3.4.3/* src/
rm -rf petsc-3.4.3

#configure
cd src
./config/configure.py \
 --prefix="$ISSM_DIR/externalpackages/petsc/install" \
 --PETSC_ARCH="$ISSM_ARCH" \
 --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
 --with-batch=1  \
 --with-debugging=0 \
 --with-shared-libraries=1 \
 --known-mpi-shared-libraries=1 \
 --with-mpi=1 \
 --with-mpi-dir=/sopt/mpi/openmpi-1.5.4_psm/intel/ \
 --with-blas-lapack-dir=/opt/intel/mkl/10.2.4.032/ \
 --download-scalapack=yes \
 --download-blacs=yes \
 --download-mumps=yes \
 --download-metis=yes \
 --download-parmetis=yes \
 --download-trilinos=yes \
 --download-euclid=yes \
 --download-hypre=yes \
 --COPTFLAGS="-lmpi -O3" \
 --FOPTFLAGS="-lmpi -O3" \
 --CXXOPTFLAGS="-lmpi -O3"

#prepare script to reconfigure petsc
cat > script.queue << EOF
#PBS -S /bin/bash
#PBS -l nodes=1:ppn=1
#PBS -q c6145
#PBS -l walltime=10

cd $(echo $ISSM_DIR)/externalpackages/petsc/src/
mpiexec -np 1 ./conftest-arch-linux2-c-opt
EOF

#print instructions
echo "== Now: cd src/ "
echo "== qsub script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
