#!/bin/bash
set -eu

# Constants
DAK_VER="6.2"

# Some cleanup
rm -rf build
rm -rf install
rm -rf tests
rm -rf src
mkdir build install src

# Download from ISSM server
$ISSM_DIR/scripts/download_external_package.bash 'https://issm.ess.uci.edu/files/externalpackages/dakota-${DAK_VER}-public.src.tar.gz' 'dakota-${DAK_VER}-public-src.tar.gz'

# Untar
tar -zxvf dakota-${DAK_VER}-public-src.tar.gz

# Move Dakota to src directory
mv dakota-${DAK_VER}.0.src/* src
rm -rf dakota-${DAK_VER}.0.src

# Set up Dakota cmake variables and config
DAK_BUILD=$ISSM_DIR/externalpackages/dakota/build
DAK_INSTALL=$ISSM_DIR/externalpackages/dakota/install
DAK_SRC=$ISSM_DIR/externalpackages/dakota/src
export MPIHOME=$ISSM_DIR/externalpackages/mpich/install
export BOOST_ROOT=$ISSM_DIR/externalpackages/boost/install

# Apply patches
cp $DAK_SRC/cmake/BuildDakotaTemplate.cmake $DAK_SRC/cmake/BuildDakotaCustom.cmake
patch $DAK_SRC/cmake/BuildDakotaCustom.cmake configs/$DAK_VER/BuildDakotaCustom.cmake.mac.patch
patch $DAK_SRC/cmake/DakotaDev.cmake configs/$DAK_VER/DakotaDev.cmake.patch
patch $DAK_SRC/CMakeLists.txt configs/$DAK_VER/CMakeLists.txt.patch
patch src/src/NonDSampling.cpp configs/$DAK_VER/NonDSampling.cpp.patch
patch src/src/NonDLocalReliability.cpp configs/$DAK_VER/NonDLocalReliability.cpp.patch
patch src/packages/pecos/src/pecos_global_defs.hpp configs/$DAK_VER/pecos_global_defs.hpp.patch

# Configure dakota
# Set your local gcc compiler here
cd $DAK_BUILD
cmake -DCMAKE_C_COMPILER=$ISSM_DIR/externalpackages/mpich/install/bin/mpicc \
	-DCMAKE_CXX_COMPILER=$ISSM_DIR/externalpackages/mpich/install/bin/mpicxx \
	-DCMAKE_Fortran_COMPILER=$ISSM_DIR/externalpackages/mpich/install/bin/mpif77 \
	-DCMAKE_CXX_FLAGS=-fdelayed-template-parsing \
	-DBOOST_ROOT:PATHNAME=$BOOST_ROOT \
	-DBoost_NO_BOOST_CMAKE=TRUE \
	-DBoost_NO_SYSTEM_PATHS=TRUE \
	-DBoost_LIBRARY_DIRS:FILEPATH=$BOOST_ROOT/lib \
	-DHAVE_ACRO=off \
	-DHAVE_JEGA=off \
	-C$DAK_SRC/cmake/BuildDakotaCustom.cmake \
	-C$DAK_SRC/cmake/DakotaDev.cmake \
	$DAK_SRC

# Snowleopard: Mpi should be made with these compilers
#-DCMAKE_CXX_COMPILER=/usr/bin/g++ -DCMAKE_CC_COMPILER=/usr/bin/gcc \
#-DCMAKE_Fortran_COMPILER=/usr/local/gfortran/bin/x86_64-apple-darwin10-gfortran \

#Compile and install dakota
if [ $# -eq 0 ];
then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
