#!/bin/bash
#

## Constants
#
ERR_NO_GET_CMD="No supported file download command was found"
ERR_NUM_ARGS="Illegal number of args"
ERR_USAGE=""

## Variables
#
OUT_FILE=""
URL=""

## Check number of args
#
if [ $# != 2 ]
then
	echo $ERR_NUM_ARGS
fi

## Retrieve args
#
URL=$1
OUT_FILE=$2

## Check if OUT_FILE already exists
#
if [ -f ${OUT_FILE} ]
then
	echo "File ${OUT_FILE} already exists and will not be downloaded..."
	exit 1
fi

## Download file
#
if [ ! -z `which wget` ]
then
	wget --no-check-certificate -O $OUT_FILE $URL
elif [ ! -z `which curl` ]
then
	curl $URL -o $OUT_FILE
else
	echo $ERR_NO_GET_CMD
	exit 1
fi

exit 0
