#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.7.6 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/download_external_package.bash 'https://issm.ess.uci.edu/files/externalpackages/petsc-lite-3.7.6.tar.gz' 'petsc-3.7.6.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.7.6.tar.gz
mv petsc-3.7.6/* src/
rm -rf petsc-3.7.6

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--with-single-library=1 \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-shared-libraries=0 \
	--with-debugging=0 \
	--with-mpi-dir="$ISSM_DIR/externalpackages/mpich/install" \
	--download-fblaslapack=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--with-x=0 \
	--download-scalapack=1 \
	--download-mumps=1 \
	--with-ssl=0 \
	--with-valgrind=0 \
	--with-pic=1 \
	--COPTFLAGS="-fPIC" \
	--CXXOPTFLAGS="-fPIC" \
	--FOPTFLAGS="-fPIC"

#Compile and intall
make
make install
