#!/bin/bash
set -eu

# Set gmt version
VER="5.4.4"

# Set tarball name
TARBALL_NAME="gmt-${VER}-win64-precompiled"
TARBALL=${TARBALL_NAME}.tar.gz

# Clean up from previous installation
rm -rf install

# Download Windows 64-bit precompiled gmsh from ISSM server
$ISSM_DIR/scripts/download_external_package.bash "https://issm.ess.uci.edu/files/externalpackages/${TARBALL}" "${TARBALL}"

# Untar gmt
tar -xvzf $TARBALL

# Rename untarred dir
mv $TARBALL_NAME install

# Clean up
rm -f $TARBALL
