#!/bin/bash
set -eu

# Set gmsh version
GMSH_VER="3.0.5"

# Set tarball name
GMSH_TARBALL_NAME="gmsh-${GMSH_VER}-mac-precompiled"

# Clean up from previous installation
rm -f $GMSH_TARBALL_NAME.tar.gz
rm -rf install src

# Download Mac precompiled gmsh from ISSM server
$ISSM_DIR/scripts/download_external_package.bash "https://issm.ess.uci.edu/files/externalpackages/${GMSH_TARBALL_NAME}.tar.gz" "${GMSH_TARBALL_NAME}.tar.gz"

# Untar gmsh
tar -xvzf $GMSH_TARBALL_NAME.tar.gz

# Copy gmsh to path expected by packager
mkdir install
cp gmsh install
rm gmsh
