#!/bin/bash
set -eu

export CC=gcc
export CXX=g++

#Some cleanup
rm -rf install

#Download from ISSM server
$ISSM_DIR/scripts/download_external_package.bash 'https://issm.ess.uci.edu/files/externalpackages/emsdk-portable.tar.gz' 'emsdk-portable.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  emsdk-portable.tar.gz
mv emsdk_portable install

cd install

./emsdk update
./emsdk install sdk-tag-1.34.12-64bit
./emsdk activate sdk-tag-1.34.12-64bit

#Related to moving the install path after installation - However, not safe to install in dir named "install" since a failure would not be noticed by jenkins when triggering
#Not reliable - when executed in subshell without sourcing the install file, this has no effect. Safer to explicitly source for each dependent externalpackage.
source emsdk_env.sh
