#!/bin/bash
set -eu

#Version numbers
M4_VER="1.4.17"
AUTOCONF_VER="2.69"
AUTOMAKE_VER="1.16.1"
LIBTOOL_VER="2.4.2"

# Clean up existing directories
rm -rf install src

# Set up for installation
mkdir install
export PATH="$ISSM_DIR/externalpackages/autotools/install/bin:$PATH"

# Install m4
echo " === INSTALLING M4 =="
$ISSM_DIR/scripts/download_external_package.bash "https://issm.ess.uci.edu/files/externalpackages/m4-$M4_VER.tar.gz" "m4-$M4_VER.tar.gz"
tar -zxvf m4-$M4_VER.tar.gz
mv m4-$M4_VER src
cd src
./configure --prefix="$ISSM_DIR/externalpackages/autotools/install"
make
make install
cd ..

#install autoconf
echo " === INSTALLING AUTOCONF =="
rm -rf src
$ISSM_DIR/scripts/download_external_package.bash "https://issm.ess.uci.edu/files/externalpackages/autoconf-$AUTOCONF_VER.tar.gz" "autoconf-$AUTOCONF_VER.tar.gz"
tar -zxvf autoconf-$AUTOCONF_VER.tar.gz
mv autoconf-$AUTOCONF_VER src
cd src 
./configure --prefix="$ISSM_DIR/externalpackages/autotools/install" 
make
make install
cd ..

#install automake
echo " === INSTALLING AUTOMAKE =="
rm -rf src
$ISSM_DIR/scripts/download_external_package.bash "https://issm.ess.uci.edu/files/externalpackages/automake-$AUTOMAKE_VER.tar.gz" "automake-$AUTOMAKE_VER.tar.gz"
tar -zxvf  automake-$AUTOMAKE_VER.tar.gz
mv automake-$AUTOMAKE_VER src
cd src 
./configure --prefix="$ISSM_DIR/externalpackages/autotools/install" 
make
make install
cd ..

#install libtool
echo " === INSTALLING LIBTOOL =="
rm -rf src
$ISSM_DIR/scripts/download_external_package.bash "https://issm.ess.uci.edu/files/externalpackages/libtool-$LIBTOOL_VER.tar.gz" "libtool-$LIBTOOL_VER.tar.gz"
tar -zxvf  libtool-$LIBTOOL_VER.tar.gz
rm libtool-$LIBTOOL_VER.tar.gz
mv libtool-$LIBTOOL_VER src
cd src 
./configure --prefix="$ISSM_DIR/externalpackages/autotools/install"
make
make install
cd ..
