#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.7.6 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'https://issm.ess.uci.edu/files/externalpackages/petsc-lite-3.7.6.tar.gz' 'petsc-3.7.6.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.7.6.tar.gz
mv petsc-3.7.6/* src/
rm -rf petsc-3.7.6

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-blas-lapack-dir="/opt/intel/compilers_and_libraries_2016.3.210/linux/mkl/lib/" \
	--with-mpi-dir="/opt/intel/compilers_and_libraries_2016.3.210/linux/mpi/intel64/" \
	--known-mpi-shared-libraries=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch=1  \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-mumps=1 \
	--download-scalapack=1 

#prepare script to reconfigure petsc
cat > script.queue << EOF
#PBS -A open
#PBS -l nodes=1:ppn=1:stmem
#PBS -l walltime=200 

module load intel/16.0.3
module load impi/5.1.3
module load mkl/11.3.3

export PATH="$PATH:." 
cd $ISSM_DIR/externalpackages/petsc/src
mpirun -np 1 ./conftest-arch-linux2-c-opt
EOF

#print instructions
echo "== Now: cd src/ "
echo "== qsub script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
