#!/bin/bash

#Some cleanup
rm -rf install petsc-3.4.2 src
mkdir install src

export cc=gcc
alias cc='gcc'

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'https://issm.ess.uci.edu/files/externalpackages/petsc-lite-3.4.2.tar.gz' 'petsc-3.4.2.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.4.2.tar.gz
mv petsc-3.4.2/* src/
rm -rf petsc-3.4.2

#configure
cd src
./config/configure.py \
 --prefix="$ISSM_DIR/externalpackages/petsc/install" \
 --PETSC_ARCH="$ISSM_ARCH" \
 --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
 --with-batch=1  \
 --with-debugging=0 \
 --with-shared-libraries=1 \
 --with-mpi=1 \
 --with-mpi-lib="$ISSM_DIR/externalpackages/mpich/install/lib/libmpich.so"\
 --with-mpi-include="$ISSM_DIR/externalpackages/mpich/install/include" \
  --known-mpi-shared-libraries=1 \
  --download-f-blas-lapack=yes \
 --download-scalapack=yes \
 --download-metis=yes \
 --download-parmetis=yes \
 --download-blacs=yes \
 --download-mumps=yes \
  --download-trilinos=yes \
 --download-euclid=yes \
 --download-hypre=yes  \
 --COPTFLAGS=" -O3 -march=corei7-avx" \
 --FOPTFLAGS=" -O3 -march=corei7-avx" \
 --CXXOPTFLAGS=" -O3 -march=corei7-avx" 

#--with-mpi-lib="/nasa/mvapich2/1.4.1/gcc.sles11/lib/libmpich.a" \
# --with-mpi-include="/nasa/mvapich2/1.4.1/gcc.sles11/include" \


#prepare script to reconfigure petsc
cat > script.queue << EOF
#PBS -S /bin/bash
#PBS -l select=1:ncpus=1:model=wes 
#PBS -l walltime=200 
#PBS -W group_list=s1010
#PBS -m e 

. /usr/share/modules/init/bash 
module load mpi-mvapich2/1.6/gcc
module load gcc/4.7.0

export PATH="$PATH:." 
export MPI_GROUP_MAX=64 
mpiexec -np 1 ./conftest-linux-gnu-ia64-intel.py
EOF

#print instructions
echo "== Now: cd src/ "
echo "== qsub -q devel script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
