#!/bin/bash
set -eu

AUTOCONF_VER="2.69"
AUTOMAKE_MIN_VER="1.16"
AUTOMAKE_BUILD_VER="${AUTOMAKE_MIN_VER}.1"
LIBTOOL_VER="2.4.2"
M4_VER="1.4.17"

AUTOCONF="autoconf-${AUTOCONF_VER}"
AUTOMAKE="automake-${AUTOMAKE_BUILD_VER}"
LIBTOOL="libtool-${LIBTOOL_VER}"
M4="m4-${M4_VER}"

AUTOCONF_TARBALL="${AUTOCONF}.tar.gz"
AUTOMAKE_TARBALL="${AUTOMAKE}.tar.gz"
LIBTOOL_TARBALL="${LIBTOOL}.tar.gz"
M4_TARBALL="${M4}.tar.gz"

# Clean up existing assets
rm -rf install src

# Set up for installation
mkdir install
export PATH="$ISSM_DIR/externalpackages/autotools/install/bin:$PATH"

# Install m4
echo " === INSTALLING M4 =="
$ISSM_DIR/scripts/DownloadExternalPackage.py "https://issm.ess.uci.edu/files/externalpackages/${M4_TARBALL}" $M4_TARBALL
tar -zxvf $M4_TARBALL
rm -f $M4_TARBALL
mv $M4 src
cd src
./configure --prefix="$ISSM_DIR/externalpackages/autotools/install"
make
make install
cd ..

# Install autoconf
echo " === INSTALLING AUTOCONF =="
rm -rf src
$ISSM_DIR/scripts/DownloadExternalPackage.py "https://issm.ess.uci.edu/files/externalpackages/${AUTOCONF_TARBALL}" $AUTOCONF_TARBALL
tar -zxvf $AUTOCONF_TARBALL
rm -f $AUTOCONF_TARBALL
mv $AUTOCONF src
cd src
./configure --prefix="$ISSM_DIR/externalpackages/autotools/install"
make
make install
cd ..

# Install automake
echo " === INSTALLING AUTOMAKE =="
rm -rf src
$ISSM_DIR/scripts/DownloadExternalPackage.py "https://issm.ess.uci.edu/files/externalpackages/${AUTOMAKE_TARBALL}" $AUTOMAKE_TARBALL
tar -zxvf $AUTOMAKE_TARBALL
rm -f $AUTOMAKE_TARBALL
mv $AUTOMAKE src
cd src
./configure --prefix="$ISSM_DIR/externalpackages/autotools/install"
make
make install
cd ..

# Install libtool
echo " === INSTALLING LIBTOOL =="
rm -rf src
$ISSM_DIR/scripts/DownloadExternalPackage.py "https://issm.ess.uci.edu/files/externalpackages/${LIBTOOL_TARBALL}" $LIBTOOL_TARBALL
tar -zxvf $LIBTOOL_TARBALL
rm -f $LIBTOOL_TARBALL
mv $LIBTOOL src
cd src
./configure --prefix="$ISSM_DIR/externalpackages/autotools/install"
make
make install
cd ..

# This patch takes care of removing options passed to the linker that causes
# the build to fail, as well as changing some flags to match up to Microsoft
# compilers.
patch ./install/share/aclocal/libtool.m4 < ./patches/libtool.m4.patch

# Small change to Automake in order to get the right flags for Microsoft's
# compiler.
patch ./install/bin/automake < ./patches/automake.patch

# This patch is for ar-lib, and removes carriage return characters that cause
# commands to overwrite themselves and be misinterpreted during linking on
# Cygwin Windows.
patch ./install/share/automake-${AUTOMAKE_MIN_VER}/ar-lib < ./patches/ar-lib.patch
