#!/bin/bash
set -eu

# Set gmsh version
VER="3.0.5"

# Set tarball name
TARBALL_NAME="gmsh-${VER}-win64-precompiled"
TARBALL=${TARBALL_NAME}.tar.gz

# Clean up from previous installation
rm -rf install

# Download Windows 64-bit precompiled gmsh from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py "https://issm.ess.uci.edu/files/externalpackages/${TARBALL}" "${TARBALL}"

# Untar gmsh
tar -xvzf $TARBALL

# Rename untarred dir
mv $TARBALL_NAME install

# Clean up
rm -f $TARBALL
