#!/bin/bash
set -eu

#Do a regular install first, and patch after
./install.sh

# This patch takes care of removing options passed to the linker that causes
# the build to fail, as well as changing some flags to match up to Microsoft
# compilers.
patch ./install/share/aclocal/libtool.m4 < ./patches/libtool.m4.patch

# Small change to Automake in order to get the right flags for Microsoft's
# compiler.
patch ./install/bin/automake < ./patches/automake.patch

# This patch is for ar-lib, and removes carriage return characters that cause
# commands to overwrite themselves and be misinterpreted during linking on
# Cygwin Windows.
patch ./install/share/automake-${AUTOMAKE_MIN_VER}/ar-lib < ./patches/ar-lib.patch
