#!/bin/bash

MATLAB_PATH="/Applications/MATLAB_R2015b.app"
PACKAGE="ISSM" # Name of directory to copy distributable files to
TARBALL_NAME="issm-mac-static_build"
TARBALL=$TARBALL_NAME.tar.gz

# Clean up from previous packaging
echo "Cleaning up existing assets"
cd $ISSM_DIR
rm -rf $PACKAGE
mkdir $PACKAGE

# Add/modify required binaries
cd $ISSM_DIR/bin

echo "Modifying generic"
cat generic_static.m | sed -e "s/generic_static/generic/g" > generic.m

echo "Moving mpiexec to bin"
if [ -f ../externalpackages/mpich/install/bin/mpiexec ]; then
	cp ../externalpackages/mpich/install/bin/mpiexec .
	cp ../externalpackages/mpich/install/bin/hydra_pmi_proxy .
else
	echo "mpich not found"
fi

echo "Moving gmsh to bin"
if [ -f ../externalpackages/gmsh/install/gmsh ]; then
	cp ../externalpackages/gmsh/install/gmsh .
else
	echo "gmsh not found"
fi

# Copy gmt to package
# NOTE: The following assumes the precompiled version of gmt
echo "Moving gmt to externalpackages"
if [ -f $ISSM_DIR/externalpackages/gmt/install/bin/gmt ]; then
	mkdir $ISSM_DIR/$PACKAGE/externalpackages
	mkdir $ISSM_DIR/$PACKAGE/externalpackages/gmt
	cp -a $ISSM_DIR/externalpackages/gmt/install/. $ISSM_DIR/$PACKAGE/externalpackages/gmt
else
	echo "gmt not found"
fi

# Check that test101 runs
cd $ISSM_DIR/test/NightlyRun
rm matlab.log
$MATLAB_PATH/bin/matlab -nodisplay -nojvm -nosplash -nodesktop -r "try, addpath $ISSM_DIR/bin $ISSM_DIR/lib; runme('id',101);exit; catch me,fprintf('%s',getReport(me)); exit; end" -logfile matlab.log

if [[ $(cat matlab.log | grep -c SUCCESS) -lt 10 ]]; then
	echo "test101 FAILED"
	exit 1;
else
	echo "test101 passed"
fi

echo "Creating tarball: ${TARBALL_NAME}"
cd $ISSM_DIR
rm -f $TARBALL
cp -rf bin lib test examples scripts $PACKAGE/

# Create link to gmt from bin
# NOTE: It is important that we are in the destination dir when sym linking so that the path is relative
if [ -f $ISSM_DIR/$PACKAGE/externalpackages/gmt/bin/gmt ]; then
	cd $ISSM_DIR/$PACKAGE/bin
	ln -s ../externalpackages/gmt/bin/gmt ./gmt
fi

cd $ISSM_DIR
tar -czf $TARBALL $PACKAGE
ls -lah $TARBALL

echo "Shipping binaries to website"

# We're using public key authentication method to upload the tarball The
# following lines check to see if the SSH Agent is running. If not, then it is
# started and relevant information is forwarded to a script.
pgrep "ssh-agent" > /dev/null
if [ $? -ne 0 ]; then
	echo "SSH Agent is not running. Starting it..."
	ssh-agent > ~/.ssh/agent.sh
else
	echo "SSH Agent is running..."
fi

source ~/.ssh/agent.sh
ssh-add ~/.ssh/macosx-bins_richese-to-ross

scp $TARBALL ross.ics.uci.edu:/var/www/html/$TARBALL

if [ $? -ne 0 ]; then
	echo "The upload failed."
	echo "Perhaps the SSH Agent was started by some other means."
	echo "Try killing the agent and running again."
fi
