#/bin/bash
#Generate a document record for a range of files in the ISSM svn directory (trunk). 

#Some functions
function parselogchangedpaths() #{{{1
{
cat $1 | while read line
do
	if [ "$line" ==  "" ]
	then
		svnlog=1
		continue
		#empty line, we are done!
	fi
	if [ "$line" ==  "------------------------------------------------------------------------" ] 
	then
		#print previous log if not empty
		if [ "$RELEASE" != "" ]
		then
			echo $LOG
		fi

		#new log coming up!
		NEWLOG=1
		LOG=""
		continue
	fi

	if [ "$NEWLOG" == "1" ] 
	then
		
		#r2714 | morlighe | 2009-12-09 11:48:20 -0800 (Wed, 09 Dec 2009) | 1 line
		RELEASE=$(echo $line | awk '{print $1}')
		USER=$(   echo $line | awk '{print $3}')
		DATE=$(   echo $line | awk '{print $5}')
		TIME=$(   echo $line | awk '{print $6}')
		NEWLOG=0
		continue
	else
		if [ "$svnlog" == "1" ] 
		then
			continue
		else
			line=`echo $line | grep -v "Changed paths:"`
			LOG=$(echo "$LOG $line")
		fi
	fi
done
} #}}}
function parselogmessages() #{{{1
{
cat $1 | while read line
do
	if [ "$line" ==  "" ]
	then
		svnlog=1
		continue
		#empty line, we are done!
	fi
	if [ "$line" ==  "------------------------------------------------------------------------" ] 
	then
		#print previous log if not empty
		if [ "$RELEASE" != "" ]
		then
			echo $LOG
		fi

		#new log coming up!
		NEWLOG=1
		LOG=""
		continue
	fi

	if [ "$NEWLOG" == "1" ] 
	then
		#r2714 | morlighe | 2009-12-09 11:48:20 -0800 (Wed, 09 Dec 2009) | 1 line
		RELEASE=$(echo $line | awk '{print $1}')
		USER=$(   echo $line | awk '{print $3}')
		DATE=$(   echo $line | awk '{print $5}')
		TIME=$(   echo $line | awk '{print $6}')
		NEWLOG=0
		continue
	else
		if [ "$svnlog" == "1" ] 
		then
			line=`echo $line | grep -v "Changed paths:"`
			LOG=$(echo "$LOG $line")
		else
			continue
		fi
	fi
done
} #}}}
function todaydate() #{{{1
{
	suffix=`date | awk '{printf("%s-%s-%s",$2,$3,$6);}'`			 
	echo $suffix;			 
} #}}}

#Archive location: 
UCI_SVN=./../
ARCHIVE_ROOT=$UCI_SVN/oecreview/Archive
TEMPLATE_DIR=$UCI_SVN/oecreview/Template
TRUNK_JPL=$UCI_SVN/trunk-jpl

#Range 
if test $# -ne 2
then
	echo "oecreview.sh needs 2 arguments specifying the svn range on which to apply the review" 
	exit 1
fi
r1=$1;
r2=$2;

#Name of archive  directory: 
ARCHIVE_DIR="$ARCHIVE_ROOT/$r1-$r2"

#Create archive subdirectory for this batch of changes
rm -rf  $ARCHIVE_DIR &&  mkdir $ARCHIVE_DIR

#create log number
echo "$r1-$r2"  > $ARCHIVE_DIR/LogNumber.tex

#create date tex
echo $(todaydate) > $ARCHIVE_DIR/Date.tex

#create revision texs
echo $r1 > $ARCHIVE_DIR/r1.tex
echo $r2 > $ARCHIVE_DIR/r2.tex

#copy template
cp  $TEMPLATE_DIR/docreview.tex $ARCHIVE_DIR/ISSM-DocReview-$r1-$r2.tex
cp  $TEMPLATE_DIR/signature.pdf $ARCHIVE_DIR/
cat $TEMPLATE_DIR/Makefile  | sed "s/TARGET=docreview/TARGET=ISSM-DocReview-$r1-$r2/g" > $ARCHIVE_DIR/Makefile

COUNTER=0
for (( i=$r1; i<$r2; i++ ))
do
	echo "Dealing with change #$i"
	j=$(($i+1));

	#get svn log for this commit
	echo " => getting log..."
	rm TEMP
	svn log -v -r$i $TRUNK_JPL > TEMP

	if [ "$(cat TEMP)" ==  "------------------------------------------------------------------------" ]
	then 
		#empty log, nothing was changed on the trunk-jpl/ (this must be a change in another direcoty), skip
		echo " => empty log (not affecting trunk-jpl)"
		continue 
	fi

	#process log
	release=$( cat TEMP | sed -n 2p | awk '{print $1}')
	user=$(    cat TEMP | sed -n 2p | awk '{print $2}')
	date=$(    cat TEMP | sed -n 2p | awk '{print $3}')
	time=$(    cat TEMP | sed -n 2p | awk '{print $4}')
	
	COUNTER=$(($COUNTER+1))

	#retrieve files affected
	echo " => getting path"
	changedpath=$(cat TEMP | parselogchangedpaths)
	echo " => getting log message"
	logmessage=$(cat TEMP | parselogmessages)

	#create diff file
	echo " => getting diff file"
	svn diff -r $i:$j $TRUNK_JPL > $ARCHIVE_DIR/ISSM-$i-$j.diff
	
	#add lines to explain the logs
	echo " => add to $ARCHIVE_DIR/log.tex"
	cat >> $ARCHIVE_DIR/log.tex << EOF
\\noindent \\textbf{Change \#$COUNTER} with diff file ISSM-$i-$j.diff: \\\\
Function name: \\\\
$(          echo $changedpath | sed 's/_/\\_/g' | sed 's/#/\\#/g' | sed 's/&/\\&/g' | sed 's/\$/\\$/g')\\\\
Export determination: 6. \\\\
Rationale: $(echo $logmessage | sed 's/_/\\_/g' | sed 's/#/\\#/g' | sed 's/&/\\&/g' | sed 's/\$/\\$/g')\\\\
\\vspace{3em}

EOF
done
rm TEMP
	
#create pdf file
cd $ARCHIVE_DIR
make

#copy pdf file in Archive directory:  
cp $ARCHIVE_DIR/ISSM-DocReview-$r1-$r2.pdf $ARCHIVE_ROOT

echo "Done! Now call Eric L."
echo "Eric, can you copy oecreview/Archive/$ARCHIVE_DIR/ISSM-DocReview-$r1-$r2.pdf to oecreview/Archive/"
