/*\file Solver.c
 *\brief: solver
 */

#include "./Solver.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Mat Kff=NULL;
	Vec pf=NULL;
	Vec uf0=NULL;
	char* solver_string=NULL;
	DataSet* parameters=NULL;

	/* output datasets: */
	Vec uf=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&SolverUsage);

	/*Input datasets: */
	FetchData(&Kff,KFF);
	FetchData(&pf,PF);
	FetchData(&uf0,UF0);
	FetchParams(&parameters,PARAMETERS);
	parameters->FindParam(&solver_string,"solverstring");

	/*!Reduce vector: */
	Solverx(&uf, Kff, pf, uf0, solver_string);

	/*write output datasets: */
	WriteData(UF,uf);

	/*Free ressources: */
	MatFree(&Kff);
	VecFree(&pf);
	VecFree(&uf0);
	VecFree(&uf);
	xfree((void**)&solver_string);
	delete parameters;

	/*end module: */
	MODULEEND();
}

void SolverUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [uf] = %s(Kff,pf,uf0,solver_string);\n",__FUNCT__);
	_printf_("\n");
}
