#!/bin/bash

MATLAB_PATH="/cygdrive/c/Programs/MATLAB/R2015a"

# Source Windows environment
source $ISSM_DIR/externalpackages/windows/windows_environment.sh

echo "Making generic_static.m work like generic.m"
cd $ISSM_DIR/bin
cat generic_static.m | sed -e "s/generic_static/generic/g" > generic.m

echo "Copying scripts from /src to /bin"
echo "----------------------------------"
rm $ISSM_DIR/bin/*.m
find $ISSM_DIR/src/m -name '*.m' | xargs cp -t $ISSM_DIR/bin
ls $ISSM_DIR/bin
echo "----------------------------------"

echo "Copying gmsh to bin"
if [ -f ../externalpackages/gmsh/install/gmsh.exe ]; then
	cp ../externalpackages/gmsh/install/gmsh.exe .
else
	echo "gmsh not found"
fi

# Check that test 101 runs
cd $ISSM_DIR/test/NightlyRun
rm matlab.log

$MATLAB_PATH/bin/matlab -nodisplay -nosplash -r "try, addpath $ISSM_DIR_WIN/bin $ISSM_DIR_WIN/lib; runme('id',101); exit; catch me,fprintf('%s',getReport(me)); exit; end" -logfile matlab.log

# Wait until MATLAB closes
sleep 5
pid=$(ps aux -W | grep MATLAB | awk '{printf("%s\n","MATLAB");}')
while [ -n "$pid" ]
do
	pid=$(ps aux -W | grep MATLAB | awk '{printf("%s\n","MATLAB");}')
	sleep 1
done

if [[ $(cat matlab.log | grep -c SUCCESS) -lt 10 ]]; then
	echo "test101 FAILED"
	exit 1;
else
	echo "test101 passed"
fi

# Create tarball
TARBALL_NAME=ISSM-Win10-64.tar.gz

cd $ISSM_DIR
rm $TARBALL_NAME
rm -rf trunk
mkdir trunk

echo "Creating tarball: ${TARBALL_NAME}"
cp -rf bin lib test examples scripts trunk/
tar -czf $TARBALL_NAME trunk
ls -lah $TARBALL_NAME

# Ship binaries to website
echo "Shipping binaries to website"

# We're using public key authentication method to upload the tarball The
# following lines check to see if the SSH Agent is running. If not, then it is
# started and relevant information is forwarded to a script.
pgrep "ssh-agent" > /dev/null

if [ $? -ne 0 ]; then
	echo "SSH agent is not running. Starting it..."
	ssh-agent > ~/.ssh/agent.sh
else
	echo "SSH agent is running..."
fi

source ~/.ssh/agent.sh
ssh-add ~/.ssh/win_bins-geidi_prime_to_ross

scp $TARBALL_NAME jenkins@ross.ics.uci.edu:/var/www/html/$TARBALL_NAME

if [ $? -ne 0 ]; then
	echo "The upload failed."
	echo "Perhaps the SSH agent was started by some other means."
	echo "Try killing the agent and running again."
fi
